/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.tuple.Tuplizer;

public abstract class EntityModeToTuplizerMapping
implements Serializable {
    private final Map<EntityMode, Tuplizer> tuplizers;

    public EntityModeToTuplizerMapping() {
        this.tuplizers = new ConcurrentHashMap<EntityMode, Tuplizer>();
    }

    public EntityModeToTuplizerMapping(Map tuplizers) {
        this.tuplizers = tuplizers;
    }

    protected void addTuplizer(EntityMode entityMode, Tuplizer tuplizer) {
        this.tuplizers.put(entityMode, tuplizer);
    }

    public EntityMode guessEntityMode(Object object) {
        for (Map.Entry<EntityMode, Tuplizer> entry : this.tuplizers.entrySet()) {
            Tuplizer tuplizer = entry.getValue();
            if (!tuplizer.isInstance(object)) continue;
            return entry.getKey();
        }
        for (Map.Entry<EntityMode, Tuplizer> entityModeTuplizerEntry : this.tuplizers.entrySet()) {
            if (!entityModeTuplizerEntry.getValue().isInstance(object)) continue;
            return entityModeTuplizerEntry.getKey();
        }
        return null;
    }

    public Tuplizer getTuplizerOrNull(EntityMode entityMode) {
        return this.tuplizers.get(entityMode);
    }

    public Tuplizer getTuplizer(EntityMode entityMode) {
        Tuplizer tuplizer = this.getTuplizerOrNull(entityMode);
        if (tuplizer == null) {
            throw new HibernateException("No tuplizer found for entity-mode [" + entityMode + "]");
        }
        return tuplizer;
    }
}

