/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.IOException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Properties;
import org.drools.RuntimeDroolsException;

public class KeyStoreHelper {
    public static final String PROP_SIGN = "drools.serialization.sign";
    public static final String PROP_PVT_KS_URL = "drools.serialization.private.keyStoreURL";
    public static final String PROP_PVT_KS_PWD = "drools.serialization.private.keyStorePwd";
    public static final String PROP_PVT_ALIAS = "drools.serialization.private.keyAlias";
    public static final String PROP_PVT_PWD = "drools.serialization.private.keyPwd";
    public static final String PROP_PUB_KS_URL = "drools.serialization.public.keyStoreURL";
    public static final String PROP_PUB_KS_PWD = "drools.serialization.public.keyStorePwd";
    private boolean signed;
    private URL pvtKeyStoreURL;
    private char[] pvtKeyStorePwd;
    private String pvtKeyAlias;
    private char[] pvtKeyPassword;
    private URL pubKeyStoreURL;
    private char[] pubKeyStorePwd;
    private KeyStore pvtKeyStore;
    private KeyStore pubKeyStore;

    public KeyStoreHelper() {
        try {
            Properties prop = System.getProperties();
            this.signed = Boolean.valueOf(prop.getProperty(PROP_SIGN, "true"));
            String url = prop.getProperty(PROP_PVT_KS_URL, "");
            if (url.length() > 0) {
                this.pvtKeyStoreURL = new URL(url);
            }
            this.pvtKeyStorePwd = prop.getProperty(PROP_PVT_KS_PWD, "").toCharArray();
            this.pvtKeyAlias = prop.getProperty(PROP_PVT_ALIAS, "");
            this.pvtKeyPassword = prop.getProperty(PROP_PVT_PWD, "").toCharArray();
            url = prop.getProperty(PROP_PUB_KS_URL, "");
            if (url.length() > 0) {
                this.pubKeyStoreURL = new URL(url);
            }
            this.pubKeyStorePwd = prop.getProperty(PROP_PUB_KS_PWD, "").toCharArray();
            this.initKeyStore();
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Error initialising KeyStore: " + e.getMessage(), e);
        }
    }

    private void initKeyStore() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        if (this.pvtKeyStoreURL != null) {
            this.pvtKeyStore = KeyStore.getInstance("JKS");
            this.pvtKeyStore.load(this.pvtKeyStoreURL.openStream(), this.pvtKeyStorePwd);
        }
        if (this.pubKeyStoreURL != null) {
            this.pubKeyStore = KeyStore.getInstance("JKS");
            this.pubKeyStore.load(this.pubKeyStoreURL.openStream(), this.pubKeyStorePwd);
        }
    }

    public byte[] signDataWithPrivateKey(byte[] data) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.pvtKeyStore == null) {
            throw new RuntimeDroolsException("Key store with private key not configured. Please configure it properly before using signed serialization.");
        }
        PrivateKey pvtkey = (PrivateKey)this.pvtKeyStore.getKey(this.pvtKeyAlias, this.pvtKeyPassword);
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initSign(pvtkey);
        sig.update(data);
        return sig.sign();
    }

    public boolean checkDataWithPublicKey(String publicKeyAlias, byte[] data, byte[] signature) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.pubKeyStore == null) {
            throw new RuntimeDroolsException("Key store with public key not configured. Please configure it properly before using signed serialization.");
        }
        Certificate cert = this.pubKeyStore.getCertificate(publicKeyAlias);
        if (cert == null) {
            throw new RuntimeDroolsException("Public certificate for key '" + publicKeyAlias + "' not found in the configured key store. Impossible to deserialize the object.");
        }
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initVerify(cert.getPublicKey());
        sig.update(data);
        return sig.verify(signature);
    }

    public boolean isSigned() {
        return this.signed;
    }

    public URL getPvtKeyStoreURL() {
        return this.pvtKeyStoreURL;
    }

    public char[] getPvtKeyStorePwd() {
        return this.pvtKeyStorePwd;
    }

    public String getPvtKeyAlias() {
        return this.pvtKeyAlias;
    }

    public char[] getPvtKeyPassword() {
        return this.pvtKeyPassword;
    }

    public URL getPubKeyStoreURL() {
        return this.pubKeyStoreURL;
    }

    public char[] getPubKeyStorePwd() {
        return this.pubKeyStorePwd;
    }

    public KeyStore getPvtKeyStore() {
        return this.pvtKeyStore;
    }

    public KeyStore getPubKeyStore() {
        return this.pubKeyStore;
    }
}

