/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

public class MySQLReplicationValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 2658231045989623858L;
    private boolean driverHasIsValidMethod;
    private transient Method isValid;
    private boolean driverHasPingMethod;
    private transient Method ping;
    protected static final String CONNECTION_CLASS = "com.mysql.jdbc.ReplicationConnection";
    private static transient Logger log;
    private static Object[] timeoutParam;

    public MySQLReplicationValidConnectionChecker() {
        try {
            this.initPing();
        }
        catch (Exception e) {
            log.warn((Object)"Cannot find the driver class defined in CONNECTION_CLASS.  Will use 'SELECT 1' instead.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLException isValidConnection(Connection c) {
        if (this.driverHasIsValidMethod) {
            try {
                this.isValid.invoke((Object)c, timeoutParam);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                log.warn((Object)"Unexpected error in ping", (Throwable)e);
                return new SQLException("ping failed: " + e.toString());
            }
        }
        if (this.driverHasPingMethod) {
            try {
                this.ping.invoke((Object)c, timeoutParam);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                log.warn((Object)"Unexpected error in ping", (Throwable)e);
                return new SQLException("ping failed: " + e.toString());
            }
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery("SELECT 1");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLException sQLException = (SQLException)e;
                return sQLException;
            }
            log.warn((Object)"Unexpected error in ping (SELECT 1)", (Throwable)e);
            SQLException sQLException = new SQLException("ping (SELECT 1) failed: " + e.toString());
            return sQLException;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
        }
        return null;
    }

    private void initPing() throws ClassNotFoundException, NoSuchMethodException {
        this.driverHasIsValidMethod = false;
        this.driverHasPingMethod = false;
        log = Logger.getLogger(MySQLReplicationValidConnectionChecker.class);
        Class<?> mysqlConnection = Thread.currentThread().getContextClassLoader().loadClass(CONNECTION_CLASS);
        try {
            this.isValid = mysqlConnection.getMethod("isValid", new Class[0]);
            this.driverHasIsValidMethod = true;
        }
        catch (NoSuchMethodException e) {
            log.info((Object)"Cannot resolve com.mysq.jdbc.ReplicationConnection.isValid method. Fallback to ping.", (Throwable)e);
        }
        catch (SecurityException e) {
            log.info((Object)"Cannot resolve com.mysq.jdbc.ReplicationConnection.isValid method. Fallback to ping.", (Throwable)e);
        }
        if (!this.driverHasIsValidMethod) {
            try {
                this.ping = mysqlConnection.getMethod("ping", new Class[0]);
                this.driverHasPingMethod = true;
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)"Cannot resolve com.mysq.jdbc.ReplicationConnection.ping method. Will use 'SELECT 1' instead.", (Throwable)e);
            }
            catch (SecurityException e) {
                log.info((Object)"Cannot resolve com.mysq.jdbc.ReplicationConnection.ping method. Will use 'SELECT 1' instead.", (Throwable)e);
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.initPing();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to resolve ping method: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    static {
        timeoutParam = new Object[0];
    }
}

