/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.config.CommonConfig;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.xb.binding.NamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonMessageContext
implements Map<String, Object> {
    private static Logger log = Logger.getLogger(CommonMessageContext.class);
    public static String ALLOW_EXPAND_TO_DOM = "org.jboss.ws.allow.expand.dom";
    public static String REMOTING_METADATA = "org.jboss.ws.remoting.metadata";
    private SerializationContext serContext;
    private EndpointMetaData epMetaData;
    private OperationMetaData opMetaData;
    private CommonConfig config;
    private MessageAbstraction message;
    protected Map<String, ScopedProperty> scopedProps = new HashMap<String, ScopedProperty>();
    protected MessageContext.Scope currentScope = MessageContext.Scope.APPLICATION;
    private boolean isModified;

    public CommonMessageContext() {
    }

    public CommonMessageContext(CommonMessageContext msgContext) {
        this.epMetaData = msgContext.epMetaData;
        this.opMetaData = msgContext.opMetaData;
        this.message = msgContext.message;
        this.serContext = msgContext.serContext;
        this.scopedProps = new HashMap<String, ScopedProperty>(msgContext.scopedProps);
        this.currentScope = msgContext.currentScope;
    }

    public MessageContext.Scope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(MessageContext.Scope currentScope) {
        this.currentScope = currentScope;
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null && this.opMetaData != null) {
            this.epMetaData = this.opMetaData.getEndpointMetaData();
        }
        return this.epMetaData;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public void setOperationMetaData(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public CommonConfig getConfig() {
        if (this.config == null) {
            this.config = this.epMetaData.getConfig();
        }
        return this.config;
    }

    public void setConfig(CommonConfig config) {
        this.config = config;
    }

    public SOAPMessage getSOAPMessage() {
        return (SOAPMessage)this.message;
    }

    public void setSOAPMessage(SOAPMessage soapMessage) {
        this.message = (MessageAbstraction)soapMessage;
        this.setModified(true);
    }

    public MessageAbstraction getMessageAbstraction() {
        return this.message;
    }

    public void setMessageAbstraction(MessageAbstraction message) {
        this.message = message;
    }

    public SerializationContext getSerializationContext() {
        if (this.serContext == null) {
            this.serContext = this.createSerializationContext();
        }
        return this.serContext;
    }

    public abstract SerializationContext createSerializationContext();

    public void setSerializationContext(SerializationContext serContext) {
        this.serContext = serContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.getSerializationContext().getNamespaceRegistry();
    }

    @Override
    public int size() {
        return this.scopedProps.size();
    }

    @Override
    public boolean isEmpty() {
        return this.scopedProps.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        ScopedProperty prop = this.scopedProps.get(key);
        return this.isValidInScope(prop);
    }

    @Override
    public boolean containsValue(Object value) {
        boolean valueFound = false;
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!prop.getValue().equals(value) || !this.isValidInScope(prop)) continue;
            valueFound = true;
            break;
        }
        return valueFound;
    }

    @Override
    public Object get(Object key) {
        Object value = null;
        ScopedProperty scopedProp = this.scopedProps.get(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("get(" + key + "): " + scopedProp));
        }
        if (this.isValidInScope(scopedProp)) {
            value = scopedProp.getValue();
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        ScopedProperty prevProp = this.scopedProps.get(key);
        if (prevProp != null && !this.isValidInScope(prevProp)) {
            throw new IllegalArgumentException("Cannot set value for HANDLER scoped property: " + key);
        }
        ScopedProperty newProp = new ScopedProperty(key, value, this.currentScope);
        if (log.isTraceEnabled()) {
            log.trace((Object)("put: " + newProp));
        }
        this.scopedProps.put(key, newProp);
        return prevProp != null ? prevProp.getValue() : null;
    }

    @Override
    public Object remove(Object key) {
        ScopedProperty prevProp = this.scopedProps.get(key);
        if (prevProp != null && !this.isValidInScope(prevProp)) {
            throw new IllegalArgumentException("Cannot set remove for HANDLER scoped property: " + key);
        }
        return this.scopedProps.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> srcMap) {
        for (String string : srcMap.keySet()) {
            try {
                Object value = srcMap.get(string);
                this.put(string, value);
            }
            catch (IllegalArgumentException ex) {
                log.debug((Object)("Ignore: " + ex.getMessage()));
            }
        }
    }

    @Override
    public void clear() {
        this.scopedProps.clear();
    }

    public boolean isModified() {
        if (XOPContext.isXOPEncodedRequest() && !XOPContext.isXOPMessage()) {
            log.debug((Object)"Disregard changes from XOP/Handler interactions");
            return false;
        }
        return this.isModified;
    }

    public void setModified(boolean modified) {
        this.isModified = modified;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.scopedProps.size());
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!this.isValidInScope(prop)) continue;
            keys.add(prop.getName());
        }
        return keys;
    }

    @Override
    public Collection<Object> values() {
        HashSet<Object> values = new HashSet<Object>(this.scopedProps.size());
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!this.isValidInScope(prop)) continue;
            values.add(prop.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        for (ScopedProperty prop : this.scopedProps.values()) {
            if (!this.isValidInScope(prop)) continue;
            String name = prop.getName();
            Object value = prop.getValue();
            ImmutableEntry<String, Object> entry = new ImmutableEntry<String, Object>(name, value);
            entries.add(entry);
        }
        return entries;
    }

    private boolean isValidInScope(ScopedProperty prop) {
        boolean valid = prop != null && (prop.getScope() == MessageContext.Scope.APPLICATION || this.currentScope == MessageContext.Scope.HANDLER);
        return valid;
    }

    public static class ScopedProperty {
        private MessageContext.Scope scope;
        private String name;
        private Object value;

        public ScopedProperty(String name, Object value, MessageContext.Scope scope) {
            this.scope = scope;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public MessageContext.Scope getScope() {
            return this.scope;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.scope + ":" + this.name + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableEntry<K, V>
    implements Map.Entry<K, V> {
        final K k;
        final V v;

        ImmutableEntry(K key, V value) {
            this.k = key;
            this.v = value;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

