/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.security.MessageDigest;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.security.auth.callback.Callback;
import org.jboss.logging.Logger;
import org.jboss.security.Base64Encoder;
import org.jboss.ws.extensions.security.EncodingOperation;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.auth.callback.UsernameTokenCallback;
import org.jboss.ws.extensions.security.auth.callback.UsernameTokenCallbackHandler;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendUsernameOperation
implements EncodingOperation {
    private static Logger log = Logger.getLogger(SendUsernameOperation.class);
    private SecurityHeader header;
    private SecurityStore store;

    public SendUsernameOperation(SecurityHeader header, SecurityStore store) {
        this.header = header;
        this.store = store;
    }

    @Override
    public void process(Document message, List<Target> targets, String username, String credential, String algorithm, boolean digest, boolean useNonce, boolean useTimestamp) throws WSSecurityException {
        String created = useTimestamp ? SendUsernameOperation.getCurrentTimestampAsString() : null;
        String nonce = useNonce ? this.store.getNonceGenerator().generateNonce() : null;
        String password = digest ? SendUsernameOperation.createPasswordDigest(nonce, created, credential) : credential;
        this.header.addToken(new UsernameToken(username, password, message, digest, nonce, created));
    }

    private static String getCurrentTimestampAsString() {
        GregorianCalendar timestamp = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        return SimpleTypeBindings.marshalDateTime((Calendar)timestamp);
    }

    public static String createPasswordDigest(String nonce, String created, String password) {
        String passwordHash = null;
        try {
            byte[] passBytes = password.getBytes("UTF-8");
            UsernameTokenCallback callback = new UsernameTokenCallback();
            HashMap options = new HashMap();
            callback.init(options);
            UsernameTokenCallbackHandler handler = new UsernameTokenCallbackHandler(nonce, created);
            handler.handle((Callback[])options.get("callbacks"));
            MessageDigest md = MessageDigest.getInstance("SHA");
            callback.preDigest(md);
            md.update(passBytes);
            callback.postDigest(md);
            byte[] hash = md.digest();
            passwordHash = Base64Encoder.encode((byte[])hash);
        }
        catch (Exception e) {
            log.error((Object)"Password hash calculation failed ", (Throwable)e);
        }
        return passwordHash;
    }
}

