/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.TupleSinkNode;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class RightInputAdapterNode
extends ObjectSource
implements TupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private final TupleSource tupleSource;
    protected boolean tupleMemoryEnabled;
    private TupleSinkNode previousTupleSinkNode;
    private TupleSinkNode nextTupleSinkNode;

    public RightInputAdapterNode(int id, TupleSource source, BuildContext context) {
        super(id);
        this.tupleSource = source;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new ObjectHashMap();
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(tuple);
        if (this.tupleMemoryEnabled) {
            ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
            memory.put(tuple, handle);
        }
        this.sink.propagateAssertObject(handle, context, workingMemory);
    }

    public void retractTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        InternalFactHandle handle = (InternalFactHandle)memory.remove(tuple);
        this.sink.propagateRetractObject(handle, context, workingMemory, true);
        workingMemory.getFactHandleFactory().destroyFactHandle(handle);
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public void remove(RuleRemovalContext context, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        if (!context.alreadyVisited(this.tupleSource)) {
            this.tupleSource.remove(context, this, workingMemories);
        }
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public TupleSinkNode getNextTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextTupleSinkNode(TupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public TupleSinkNode getPreviousTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousTupleSinkNode(TupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }
}

