/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.compress;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class CompressingMarshaller
extends SerializableMarshaller {
    public static final String DATATYPE = "compressible";
    private Marshaller wrappedMarshaller;
    private static final long serialVersionUID = 8731343309128430753L;

    public CompressingMarshaller() {
    }

    public CompressingMarshaller(Marshaller marshaller) {
        this.wrappedMarshaller = marshaller;
    }

    public OutputStream getMarshallingStream(OutputStream outputStream) throws IOException {
        SelfCleaningGZipOutputStream gzos = new SelfCleaningGZipOutputStream(outputStream);
        DecomposableBufferedOutputStream bos = new DecomposableBufferedOutputStream(gzos);
        return bos;
    }

    public void write(Object dataObject, OutputStream output, int version) throws IOException {
        SelfCleaningGZipOutputStream gzos = null;
        DecomposableBufferedOutputStream bos = null;
        if (output instanceof DecomposableBufferedOutputStream) {
            bos = (DecomposableBufferedOutputStream)output;
            gzos = (SelfCleaningGZipOutputStream)bos.getWrappedStream();
            gzos.refreshDeflater();
        } else {
            gzos = new SelfCleaningGZipOutputStream(output);
            bos = new DecomposableBufferedOutputStream(gzos);
        }
        ObjectOutputStream oos = SerializationStreamFactory.getManagerInstance(this.getSerializationType()).createOutput(bos);
        if (this.wrappedMarshaller != null) {
            if (this.wrappedMarshaller instanceof VersionedMarshaller) {
                ((VersionedMarshaller)this.wrappedMarshaller).write(dataObject, oos, version);
            } else {
                this.wrappedMarshaller.write(dataObject, oos);
            }
        } else {
            super.write(dataObject, oos, version);
        }
        oos.flush();
        bos.flush();
        gzos.finish();
        gzos.flush();
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new CompressingMarshaller(this.wrappedMarshaller);
    }

    static class DecomposableBufferedOutputStream
    extends BufferedOutputStream {
        DecomposableBufferedOutputStream(OutputStream out, int size) {
            super(out, size);
        }

        DecomposableBufferedOutputStream(OutputStream out) {
            super(out);
        }

        OutputStream getWrappedStream() {
            return this.out;
        }
    }

    static class SelfCleaningGZipOutputStream
    extends GZIPOutputStream {
        boolean used;

        public SelfCleaningGZipOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        void refreshDeflater() {
            if (this.used) {
                this.def = new Deflater(-1, true);
                this.crc.reset();
            } else {
                this.used = true;
            }
        }

        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }
    }
}

