/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowNoFileLockStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore;
import java.io.File;
import java.io.IOException;

public class HashedStore
extends ShadowNoFileLockStore {
    public static final char SHADOWCHAR = '!';
    private static final int DEFAULT_NUMBER_DIRECTORIES = 255;
    private static final String HASH_SEPARATOR = "#";
    private static int NUMBEROFDIRECTORIES = 255;

    public int typeIs() {
        return 5;
    }

    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_HashedStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_HashedStore();
    }

    public static ShadowingStore create() {
        return new HashedStore("");
    }

    public static ShadowingStore create(Object[] param) {
        int ss;
        String location;
        block5: {
            if (param == null) {
                return null;
            }
            location = (String)param[0];
            Integer shareStatus = (Integer)param[1];
            ss = 14;
            if (shareStatus != null) {
                try {
                    if (shareStatus == 13) {
                        ss = 13;
                    }
                }
                catch (Exception e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_1", new Object[]{e});
                }
            }
        }
        return new HashedStore(location, ss);
    }

    public static ShadowingStore create(ObjectName param) {
        if (param == null) {
            return null;
        }
        return new HashedStore(param);
    }

    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        File f;
        String[] entry;
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "HashedStore.allObjUids(" + tName + ", " + state + ", " + match + ")");
        }
        String directory = this.locateStore(this.getStoreName());
        OutputObjectState store = new OutputObjectState();
        directory = tName != null && tName.charAt(0) == File.separatorChar ? directory + tName.substring(1, tName.length()) : directory + tName;
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        if ((entry = (f = new File(directory)).list()) != null && entry.length > 0) {
            for (int i = 0; i < entry.length; ++i) {
                File dir;
                if (!Character.isDigit(entry[i].charAt(1)) && !entry[i].startsWith(HASH_SEPARATOR) || !(dir = new File(directory + entry[i])).isDirectory()) continue;
                String[] dirEnt = dir.list();
                for (int j = 0; j < dirEnt.length; ++j) {
                    try {
                        Uid aUid = new Uid(dirEnt[j], true);
                        if (!aUid.valid() || aUid.equals(Uid.nullUid())) {
                            String revealed = this.revealedId(dirEnt[j]);
                            aUid = this.present(revealed, dirEnt) ? null : new Uid(revealed);
                        }
                        if (!aUid.notEquals(Uid.nullUid()) || match != 0 && !this.isType(aUid, tName, match)) continue;
                        aUid.pack(store);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    catch (IOException e) {
                        throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_5"));
                    }
                }
            }
        }
        try {
            Uid.nullUid().pack(store);
        }
        catch (IOException e) {
            throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_6"));
        }
        state.setBuffer(store.buffer());
        store = null;
        return true;
    }

    protected HashedStore() {
        this(14);
    }

    protected HashedStore(int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedStore( " + shareStatus + " )");
        }
    }

    protected HashedStore(String locationOfStore) {
        this(locationOfStore, 14);
    }

    protected HashedStore(String locationOfStore, int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedStore(" + locationOfStore + ")");
        }
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            tsLogger.arjLogger.warn(e.getMessage());
            throw new FatalError(e.toString());
        }
    }

    protected HashedStore(ObjectName objName) {
        super(objName);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedStore(" + objName + ")");
        }
        try {
            this.setupStore("");
        }
        catch (ObjectStoreException e) {
            tsLogger.arjLogger.warn(e.getMessage());
            throw new FatalError(e.toString());
        }
    }

    protected String truncate(String value) {
        int nextIndex;
        int lastIndex = value.lastIndexOf(HASH_SEPARATOR);
        String toReturn = value;
        if (lastIndex != -1 && (nextIndex = value.lastIndexOf(HASH_SEPARATOR, lastIndex - 1)) != -1) {
            char[] bitInbetween = new char[lastIndex - nextIndex - 1];
            boolean isDigit = true;
            value.getChars(nextIndex + 1, lastIndex, bitInbetween, 0);
            for (int i = 0; i < bitInbetween.length && isDigit; ++i) {
                if (Character.isDigit(bitInbetween[i])) continue;
                isDigit = false;
            }
            if (isDigit) {
                toReturn = value.substring(lastIndex + 1);
            }
        }
        return toReturn;
    }

    protected String genPathName(Uid objUid, String tName, int otype) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.genPathName(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(otype) + ")");
        }
        String storeName = this.locateStore(this.getStoreName());
        String fname = null;
        String cPtr = null;
        int uidHash = objUid.hashCode();
        String os = objUid.fileStringForm();
        String hashDir = HASH_SEPARATOR + uidHash % NUMBEROFDIRECTORIES + HASH_SEPARATOR + File.separator;
        if (tName == null || tName.length() == 0) {
            cPtr = "";
        } else {
            cPtr = tName;
            if (FileSystemStore.rewriteSeparator && cPtr.indexOf(47) != -1) {
                cPtr = cPtr.replace('/', File.separatorChar);
            }
        }
        if (cPtr.charAt(0) == File.separatorChar) {
            cPtr = cPtr.substring(1, cPtr.length());
        }
        if ((fname = cPtr.charAt(cPtr.length() - 1) != File.separatorChar ? storeName + cPtr + File.separator + hashDir + os : storeName + cPtr + hashDir + os).charAt(fname.length() - 1) == File.separatorChar) {
            fname = fname.substring(0, fname.length() - 2);
        }
        if (otype == 10) {
            fname = fname + '!';
        }
        return fname;
    }

    private final boolean present(String id, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    static {
        String numberOfDirs = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.hashedDirectories");
        if (numberOfDirs != null) {
            try {
                Integer i = new Integer(numberOfDirs);
                NUMBEROFDIRECTORIES = i;
                if (NUMBEROFDIRECTORIES <= 0) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_2", new Object[]{numberOfDirs});
                    }
                    NUMBEROFDIRECTORIES = 255;
                }
            }
            catch (NumberFormatException e) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_3", new Object[]{numberOfDirs});
                }
                throw new FatalError("Invalid hash directory number: " + numberOfDirs);
            }
            catch (Exception e) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_4", new Object[]{e});
                }
                throw new FatalError(e.toString());
            }
        }
    }
}

