/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.util.LangUtils;

public class UsernamePasswordCredentials
implements Credentials {
    private String userName;
    private String password;

    public UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Username:password string may not be null");
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            this.userName = string.substring(0, n);
            this.password = string.substring(n + 1);
        } else {
            this.userName = string;
        }
    }

    public UsernamePasswordCredentials(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Username may not be null");
        }
        this.userName = string;
        this.password = string2;
    }

    public void setUserName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Username may not be null");
        }
        this.userName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.userName);
        stringBuffer.append(":");
        stringBuffer.append(this.password == null ? "null" : this.password);
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.userName);
        n = LangUtils.hashCode(n, this.password);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)object;
            if (LangUtils.equals(this.userName, usernamePasswordCredentials.userName) && LangUtils.equals(this.password, usernamePasswordCredentials.password)) {
                return true;
            }
        }
        return false;
    }
}

