/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAllInputDeployer
extends AbstractDeployer {
    private Set<String> optionalInputs = CollectionsFactory.createLazySet();

    protected boolean hasAllRequiredInputs(DeploymentUnit unit) {
        Set<String> inputs = this.getInputs();
        if (inputs != null && !inputs.isEmpty()) {
            for (String input : inputs) {
                if (this.optionalInputs.contains(input) || unit.isAttachmentPresent(input)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void deploy(DeploymentUnit unit) throws DeploymentException {
        if (this.hasAllRequiredInputs(unit)) {
            this.internalDeploy(unit);
        }
    }

    protected abstract void internalDeploy(DeploymentUnit var1) throws DeploymentException;

    @Override
    public final void undeploy(DeploymentUnit unit) {
        if (this.hasAllRequiredInputs(unit)) {
            this.internalUndeploy(unit);
        }
    }

    protected void internalUndeploy(DeploymentUnit unit) {
    }

    public void addOptionalInput(Class<?> input) {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        this.addOptionalInput(input.getName());
    }

    public void addOptionalInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        this.optionalInputs.add(input);
    }

    public void setOptionalInputs(Set<String> optionalInputs) {
        this.optionalInputs = optionalInputs;
    }
}

