/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.plugins.graph.Search;
import org.jboss.dependency.plugins.graph.SearchDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.dependency.spi.graph.LookupStrategy;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.xb.annotations.JBossXmlAttribute;

@XmlType(name="injectionType")
public class AbstractDependencyValueMetaData
extends AbstractValueMetaData {
    private static final long serialVersionUID = 3L;
    protected transient KernelControllerContext context;
    protected transient ControllerState optionalWhenRequired;
    protected String property;
    protected ControllerState whenRequiredState;
    protected ControllerState dependentState;
    protected SearchInfo search = Search.DEFAULT;

    public AbstractDependencyValueMetaData() {
    }

    public AbstractDependencyValueMetaData(Object value) {
        super(value);
    }

    public AbstractDependencyValueMetaData(Object value, String property) {
        super(value);
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    @XmlAttribute
    public void setProperty(String property) {
        this.property = property;
    }

    @XmlAttribute(name="whenRequired")
    public void setWhenRequiredState(ControllerState whenRequiredState) {
        this.whenRequiredState = whenRequiredState;
        this.flushJBossObjectCache();
    }

    public ControllerState getWhenRequiredState() {
        return this.whenRequiredState;
    }

    @XmlAttribute(name="state")
    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    @XmlAttribute(name="bean")
    @JBossXmlAttribute(type=String.class)
    public void setValue(Object value) {
        super.setValue(value);
    }

    @XmlAnyElement
    @ManagementProperty(ignored=true)
    public void setValueObject(Object value) {
        if (value == null) {
            this.setValue(null);
        } else if (value instanceof ValueMetaData) {
            this.setValue(value);
        } else {
            this.setValue(new AbstractValueMetaData(value));
        }
    }

    @XmlAttribute(name="search")
    public void setSearch(SearchInfo search) {
        this.search = search;
    }

    public SearchInfo getSearch() {
        return this.search;
    }

    protected boolean isSearchApplied() {
        return this.search != Search.DEFAULT;
    }

    protected boolean isLookupValid(ControllerContext lookup) {
        return lookup != null;
    }

    protected boolean isOptional() {
        return false;
    }

    protected void addOptionalDependency(Controller controller, ControllerContext lookup) {
        OptionalDependencyItem dependency = new OptionalDependencyItem(this.context.getName(), lookup.getName(), lookup.getState());
        this.context.getDependencyInfo().addIDependOn((DependencyItem)dependency);
        lookup.getDependencyInfo().addDependsOnMe((DependencyItem)dependency);
    }

    protected ControllerContext getControllerContext(Object name, ControllerState state) {
        Controller controller = this.context.getController();
        LookupStrategy strategy = this.search.getStrategy();
        return strategy.getContext(controller, name, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        Object result;
        ControllerState state = this.dependentState;
        if (state == null) {
            state = ControllerState.INSTALLED;
        }
        if (this.context == null) {
            throw new IllegalStateException("No context for " + this);
        }
        ControllerContext lookup = this.getControllerContext(this.getUnderlyingValue(), state);
        if (!this.isLookupValid(lookup)) {
            throw new Error("Should not be here - dependency failed - " + this);
        }
        if (lookup == null) {
            return null;
        }
        if (this.isOptional()) {
            Controller controller = this.context.getController();
            this.addOptionalDependency(controller, lookup);
        }
        if (this.property != null && this.property.length() > 0) {
            if (!(lookup instanceof AttributeDispatchContext)) throw new IllegalArgumentException("Cannot use property attribute, context is not AttributeDispatchContext: " + lookup + ", metadata: " + this);
            AttributeDispatchContext adc = (AttributeDispatchContext)lookup;
            result = adc.get(this.property);
            return info != null ? info.convertValue(result) : result;
        } else {
            result = lookup.getTarget();
        }
        return info != null ? info.convertValue(result) : result;
    }

    protected boolean addDependencyItem() {
        return true;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        if (this.search == null) {
            throw new IllegalArgumentException("Null search");
        }
        this.context = visitor.getControllerContext();
        ControllerState whenRequired = this.whenRequiredState;
        if (whenRequired == null) {
            whenRequired = visitor.getContextState();
        }
        if (this.isOptional()) {
            this.optionalWhenRequired = whenRequired;
        }
        if (this.addDependencyItem()) {
            Object name = this.context.getName();
            Object iDependOn = this.getUnderlyingValue();
            Object item = this.isSearchApplied() ? new SearchDependencyItem(name, iDependOn, whenRequired, this.dependentState, this.search) : new AbstractDependencyItem(name, iDependOn, whenRequired, this.dependentState);
            visitor.addDependency((DependencyItem)item);
        }
        super.initialVisit(visitor);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.property != null) {
            buffer.append(" property=").append(this.property);
        }
        if (this.whenRequiredState != null) {
            buffer.append(" whenRequiredState=").append(this.whenRequiredState.getStateString());
        }
        if (this.dependentState != null) {
            buffer.append(" dependentState=").append(this.dependentState.getStateString());
        }
        if (this.isSearchApplied()) {
            buffer.append(" search=").append((Object)this.search);
        }
    }

    public AbstractDependencyValueMetaData clone() {
        return (AbstractDependencyValueMetaData)super.clone();
    }

    protected class OptionalDependencyItem
    extends SearchDependencyItem {
        public OptionalDependencyItem(Object name, Object iDependOn, ControllerState dependentState) {
            super(name, iDependOn, AbstractDependencyValueMetaData.this.optionalWhenRequired, dependentState, AbstractDependencyValueMetaData.this.search);
            this.setResolved(true);
        }
    }
}

