/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.AntClassLoader;
import org.xml.sax.InputSource;
import xdoclet.loader.LoaderMessages;
import xdoclet.loader.XDocletModule;
import xdoclet.loader.XDocletXmlParser;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;

public class ModuleFinder {
    private static final FileFilter jarFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    };
    private static String classpath;
    private static List modules;

    public static String getClasspath() {
        return classpath;
    }

    public static File getNewestFileOnClassPath() {
        List moduleFiles = ModuleFinder.findModuleFiles();
        long newest = Long.MIN_VALUE;
        File newestFile = null;
        for (File moduleFile : moduleFiles) {
            if (moduleFile.lastModified() < newest) continue;
            newestFile = moduleFile;
            newest = moduleFile.lastModified();
        }
        return newestFile;
    }

    public static void setClasspath(String classpath) {
        ModuleFinder.classpath = classpath;
    }

    public static void initClasspath(Class clazz) {
        if (System.getProperty("xdoclet.class.path") == null) {
            try {
                classpath = ((AntClassLoader)clazz.getClassLoader()).getClasspath();
            }
            catch (ClassCastException e) {
                classpath = System.getProperty("java.class.path");
            }
        } else {
            classpath = System.getProperty("xdoclet.class.path");
        }
    }

    public static List findModules() {
        if (modules == null) {
            modules = new ArrayList();
            Log log = LogUtil.getLog(ModuleFinder.class, "findModules");
            log.debug((Object)Translator.getString(LoaderMessages.class, "REGISTERING_MODULES"));
            XDocletXmlParser parser = new XDocletXmlParser();
            List moduleFiles = ModuleFinder.findModuleFiles();
            for (File file : moduleFiles) {
                if (file.exists()) {
                    try {
                        InputStream xdocletXmlIs = null;
                        URL xtagsURL = null;
                        if (file.isDirectory()) {
                            xdocletXmlIs = new FileInputStream(new File(file, "META-INF" + File.separator + "xdoclet.xml"));
                            xtagsURL = new File(file, "META-INF" + File.separator + "xtags.xml").toURL();
                        } else {
                            JarFile jar = new JarFile(file);
                            JarEntry xdocletXml = jar.getJarEntry("META-INF/xdoclet.xml");
                            xtagsURL = new URL(new URL("jar:" + file.toURL() + "!/"), "META-INF/xtags.xml");
                            if (xdocletXml != null) {
                                log.debug((Object)Translator.getString(LoaderMessages.class, "PARSING_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                                xdocletXmlIs = jar.getInputStream(xdocletXml);
                            } else {
                                log.debug((Object)Translator.getString(LoaderMessages.class, "SKIP_NO_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                            }
                        }
                        if (xdocletXmlIs == null) continue;
                        InputSource in = new InputSource(xdocletXmlIs);
                        in.setSystemId(xtagsURL.toString());
                        XDocletModule module = parser.parse(in);
                        if (module != null) {
                            module.setXTagsDefinitionURL(xtagsURL);
                            modules.add(module);
                            continue;
                        }
                        log.warn((Object)Translator.getString(LoaderMessages.class, "BAD_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                        continue;
                    }
                    catch (ZipException ze) {
                        log.warn((Object)Translator.getString(LoaderMessages.class, "INVALID_ZIP_FILE", new String[]{file.getName()}));
                        continue;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(Translator.getString(LoaderMessages.class, "LOAD_MODULE_ERROR", new String[]{e.getMessage()}));
                    }
                }
                log.warn((Object)Translator.getString(LoaderMessages.class, "NONEXISTANT_CLASSPATH_ENTRY", new String[]{file.getAbsolutePath()}));
            }
            log.debug((Object)Translator.getString(LoaderMessages.class, "DONE_REGISTERING_MODULES", new String[]{String.valueOf(modules.size())}));
        }
        return modules;
    }

    public static void resetFoundModules() {
        modules = null;
    }

    private static List findModuleFiles() {
        if (classpath == null) {
            throw new IllegalStateException(Translator.getString(LoaderMessages.class, "INIT_CLASSPATH_NOT_CALLED"));
        }
        ArrayList<File> result = new ArrayList<File>();
        StringTokenizer pathTokenizer = new StringTokenizer(classpath, System.getProperty("path.separator"));
        while (pathTokenizer.hasMoreTokens()) {
            File file = new File(pathTokenizer.nextToken());
            if (file.isDirectory()) {
                if (!new File(file, "META-INF" + File.separator + "xdoclet.xml").exists()) continue;
                result.add(file);
                continue;
            }
            if (!jarFilter.accept(file)) continue;
            result.add(file);
        }
        return result;
    }

    static {
        modules = null;
    }
}

