/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.ejb3.cache.tree.ContextInUseException;
import org.jboss.logging.Logger;

public class AbortableLRUAlgorithm
extends LRUAlgorithm {
    private static final Logger log = Logger.getLogger(AbortableLRUAlgorithm.class);

    protected boolean evictCacheNode(Fqn fqn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to evict cache node with fqn of " + fqn));
        }
        try {
            this.evictionActionPolicy.evict(fqn);
        }
        catch (ContextInUseException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Eviction of " + fqn + " aborted as bean is in use"));
            }
            return false;
        }
        catch (TimeoutException e) {
            log.warn((Object)("Eviction of " + fqn + " timed out, retrying later"));
            log.debug((Object)e, (Throwable)e);
            return false;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ContextInUseException) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Eviction of " + fqn + " aborted as bean is in use"));
                }
                return false;
            }
            log.error((Object)("Eviction of " + fqn + " failed"), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Eviction of " + fqn + " failed"), (Throwable)e);
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Eviction of cache node with fqn of " + fqn + " successful"));
        }
        return true;
    }
}

