/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2.timestamp;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.jbc2.TransactionalDataRegionAdapter;
import org.hibernate.cache.jbc2.util.CacheHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class ClusteredConcurrentTimestampsRegionImpl
extends TransactionalDataRegionAdapter
implements TimestampsRegion {
    public static final String TYPE = "TS";
    private final ConcurrentHashMap localCache = new ConcurrentHashMap();

    public ClusteredConcurrentTimestampsRegionImpl(Cache jbcCache, String regionName, String regionPrefix, Properties properties) {
        super(jbcCache, regionName, regionPrefix, null);
        jbcCache.addCacheListener((Object)this);
        this.populateLocalCache();
    }

    @Override
    protected Fqn<String> createRegionFqn(String regionName, String regionPrefix) {
        return ClusteredConcurrentTimestampsRegionImpl.getTypeFirstRegionFqn(regionName, regionPrefix, TYPE);
    }

    public void evict(Object key) throws CacheException {
        Option opt = this.getNonLockingDataVersionOption(true);
        CacheHelper.removeNode(this.getCacheInstance(), this.getRegionFqn(), key, opt);
    }

    public void evictAll() throws CacheException {
        Option opt = this.getNonLockingDataVersionOption(true);
        CacheHelper.removeAll(this.getCacheInstance(), this.getRegionFqn(), opt);
    }

    public Object get(Object key) throws CacheException {
        Object[] vals;
        Entry entry = this.getLocalEntry(key);
        Object timestamp = entry.getCurrent();
        if (timestamp == null && (vals = (Object[])this.suspendAndGet(key, null, false)) != null) {
            this.storeDataFromJBC(key, vals);
            timestamp = entry.getCurrent();
        }
        return timestamp;
    }

    public void put(Object key, Object value) throws CacheException {
        throw new UnsupportedOperationException("Prototype only; Hibernate core must change the API before really using");
    }

    public void preInvalidate(Object key, Object value) throws CacheException {
        Entry entry = this.getLocalEntry(key);
        if (entry.preInvalidate(value)) {
            this.putInJBossCache(key, entry);
        }
    }

    public void invalidate(Object key, Object value, Object preInvalidateValue) throws CacheException {
        Entry entry = this.getLocalEntry(key);
        if (entry.invalidate(value, preInvalidateValue)) {
            this.putInJBossCache(key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInJBossCache(Object key, Entry entry) {
        boolean locked = false;
        try {
            entry.acquireJBCWriteMutex();
            locked = true;
            Transaction tx = this.suspend();
            try {
                Option opt = this.getNonLockingDataVersionOption(false);
                opt.setForceAsynchronous(true);
                CacheHelper.put(this.getCacheInstance(), this.getRegionFqn(), key, entry.getJBCUpdateValues(), opt);
            }
            finally {
                this.resume(tx);
            }
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted while acquiring right to update " + key, (Throwable)e);
        }
        finally {
            if (locked) {
                entry.releaseJBCWriteMutex();
            }
        }
    }

    @Override
    public void destroy() throws CacheException {
        this.getCacheInstance().removeCacheListener((Object)this);
        super.destroy();
        this.localCache.clear();
    }

    @Override
    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        Fqn fqn = event.getFqn();
        Fqn regFqn = this.getRegionFqn();
        if (fqn.size() == regFqn.size() + 1 && fqn.isChildOf(regFqn)) {
            Object key = fqn.get(regFqn.size());
            Object[] vals = (Object[])event.getData().get("item");
            this.storeDataFromJBC(key, vals);
        }
    }

    private void storeDataFromJBC(Object key, Object[] vals) {
        Entry entry = this.getLocalEntry(key);
        if (vals[0].equals(vals[1])) {
            entry.preInvalidate(vals[0]);
        } else {
            entry.invalidate(vals[0], vals[1]);
        }
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        Fqn regFqn;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        Fqn fqn = event.getFqn();
        if (fqn.isChildOrEquals(regFqn = this.getRegionFqn())) {
            if (fqn.size() == regFqn.size()) {
                this.localCache.clear();
            } else {
                Object key = fqn.get(regFqn.size());
                this.localCache.remove(key);
            }
        }
    }

    private void populateLocalCache() {
        Set children = CacheHelper.getChildrenNames(this.getCacheInstance(), this.getRegionFqn());
        for (Object key : children) {
            Object[] vals = (Object[])this.suspendAndGet(key, null, false);
            if (vals == null) continue;
            this.storeDataFromJBC(key, vals);
        }
    }

    private Entry getLocalEntry(Object key) {
        Entry entry = new Entry();
        Entry oldEntry = this.localCache.putIfAbsent(key, entry);
        return oldEntry == null ? entry : oldEntry;
    }

    private class Entry {
        private Semaphore writeMutex = new Semaphore(1);
        private boolean preInvalidated = false;
        private Object preInval = null;
        private Object current = null;

        private Entry() {
        }

        void acquireJBCWriteMutex() throws InterruptedException {
            this.writeMutex.acquire();
        }

        void releaseJBCWriteMutex() {
            this.writeMutex.release();
        }

        synchronized boolean preInvalidate(Object newVal) {
            boolean result = false;
            if (newVal instanceof Comparable) {
                if (this.current == null || ((Comparable)newVal).compareTo(this.current) > 0) {
                    this.preInval = this.current = newVal;
                    this.preInvalidated = true;
                    result = true;
                }
            } else {
                this.preInval = this.current = newVal;
                result = true;
            }
            return result;
        }

        synchronized boolean invalidate(Object newVal, Object preInvalidateValue) {
            boolean result = false;
            if (this.current == null) {
                this.current = newVal;
                this.preInval = preInvalidateValue;
                this.preInvalidated = false;
                result = true;
            } else if (this.preInvalidated) {
                if (newVal instanceof Comparable) {
                    if (this.safeEquals(preInvalidateValue, this.preInval) || ((Comparable)newVal).compareTo(this.preInval) > 0) {
                        this.current = newVal;
                        this.preInval = preInvalidateValue;
                        this.preInvalidated = false;
                        result = true;
                    }
                } else {
                    this.current = newVal;
                    this.preInval = preInvalidateValue;
                    result = true;
                }
            } else if (newVal instanceof Comparable && this.safeEquals(preInvalidateValue, this.preInval) && ((Comparable)newVal).compareTo(this.current) > 0) {
                this.current = newVal;
                this.preInval = preInvalidateValue;
                result = true;
            }
            return result;
        }

        synchronized Object getCurrent() {
            return this.current;
        }

        synchronized Object getPreInval() {
            return this.preInval;
        }

        synchronized Object[] getJBCUpdateValues() {
            return new Object[]{this.current, this.preInval};
        }

        private boolean safeEquals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }
}

