/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.ws.extensions.security.QNameTarget;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WsuIdTarget;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.exception.FailedCheckException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.RequireOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireTargetableOperation
implements RequireOperation {
    private List<Target> targets;

    public RequireTargetableOperation(List<Target> targets) {
        this.targets = targets;
    }

    private Collection<String> resolveTarget(Document message, Target target) throws WSSecurityException {
        if (target instanceof QNameTarget) {
            return this.resolveQNameTarget(message, (QNameTarget)target);
        }
        if (target instanceof WsuIdTarget) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(((WsuIdTarget)target).getId());
            return result;
        }
        throw new WSSecurityException("Unknown target");
    }

    private Collection<String> resolveQNameTarget(Document message, QNameTarget target) throws WSSecurityException {
        QName name = target.getName();
        Element element = Util.findElement(message.getDocumentElement(), name);
        if (element == null) {
            throw new FailedCheckException("Required QName was not present: " + name);
        }
        String id = Util.getWsuId(element);
        if (id == null) {
            throw new FailedCheckException("Required element did not contain a wsu:id.");
        }
        ArrayList<String> result = new ArrayList<String>(1);
        result.add(id);
        return result;
    }

    @Override
    public void process(Document message, SecurityHeader header, Collection<String> processedIds) throws WSSecurityException {
        if (this.targets == null || this.targets.size() == 0) {
            String namespace = message.getDocumentElement().getNamespaceURI();
            this.targets = new ArrayList<Target>(1);
            this.targets.add(new QNameTarget(new QName(namespace, "Body"), true));
        }
        for (Target target : this.targets) {
            Collection<String> ids = this.resolveTarget(message, target);
            if (processedIds.containsAll(ids)) continue;
            throw new FailedCheckException("Required elements for encryption and or signing are not all present.");
        }
    }
}

