/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import org.hornetq.utils.json.JSONObject;

public class AddressSettingsInfo {
    private String addressFullMessagePolicy;
    private long maxSizeBytes;
    private int pageSizeBytes;
    private int maxDeliveryAttempts;
    private long redeliveryDelay;
    private String deadLetterAddress;
    private String expiryAddress;
    private boolean lastValueQueue;
    private long redistributionDelay;
    private boolean sendToDLAOnNoRoute;

    public static final AddressSettingsInfo from(String jsonString) throws Exception {
        JSONObject object = new JSONObject(jsonString);
        return new AddressSettingsInfo(object.getString("addressFullMessagePolicy"), object.getLong("maxSizeBytes"), object.getInt("pageSizeBytes"), object.getInt("maxDeliveryAttempts"), object.getLong("redeliveryDelay"), object.getString("DLA"), object.getString("expiryAddress"), object.getBoolean("lastValueQueue"), object.getLong("redistributionDelay"), object.getBoolean("sendToDLAOnNoRoute"));
    }

    public AddressSettingsInfo(String addressFullMessagePolicy, long maxSizeBytes, int pageSizeBytes, int maxDeliveryAttempts, long redeliveryDelay, String deadLetterAddress, String expiryAddress, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        this.maxSizeBytes = maxSizeBytes;
        this.pageSizeBytes = pageSizeBytes;
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        this.redeliveryDelay = redeliveryDelay;
        this.deadLetterAddress = deadLetterAddress;
        this.expiryAddress = expiryAddress;
        this.lastValueQueue = lastValueQueue;
        this.redistributionDelay = redistributionDelay;
        this.sendToDLAOnNoRoute = sendToDLAOnNoRoute;
    }

    public String getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public int getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public String getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public String getExpiryAddress() {
        return this.expiryAddress;
    }

    public boolean isLastValueQueue() {
        return this.lastValueQueue;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute;
    }
}

