/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.engine.transaction.Isolater;
import org.hibernate.event.EventSource;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InsertSelect;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;

public abstract class AbstractStatementExecutor
implements StatementExecutor {
    private final Logger log;
    private final HqlSqlWalker walker;
    private List idSelectParameterSpecifications = Collections.EMPTY_LIST;

    public AbstractStatementExecutor(HqlSqlWalker walker, Logger log) {
        this.walker = walker;
        this.log = log;
    }

    protected HqlSqlWalker getWalker() {
        return this.walker;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.walker.getSessionFactoryHelper().getFactory();
    }

    protected List getIdSelectParameterSpecifications() {
        return this.idSelectParameterSpecifications;
    }

    protected abstract Queryable[] getAffectedQueryables();

    protected String generateIdInsertSelect(Queryable persister, String tableAlias, AST whereClause) {
        Select select = new Select(this.getFactory().getDialect());
        SelectFragment selectFragment = new SelectFragment().addColumns(tableAlias, persister.getIdentifierColumnNames(), persister.getIdentifierColumnNames());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        String rootTableName = persister.getTableName();
        String fromJoinFragment = persister.fromJoinFragment(tableAlias, true, false);
        String whereJoinFragment = persister.whereJoinFragment(tableAlias, true, false);
        select.setFromClause(rootTableName + ' ' + tableAlias + fromJoinFragment);
        if (whereJoinFragment == null) {
            whereJoinFragment = "";
        } else if ((whereJoinFragment = whereJoinFragment.trim()).startsWith("and")) {
            whereJoinFragment = whereJoinFragment.substring(4);
        }
        String userWhereClause = "";
        if (whereClause.getNumberOfChildren() != 0) {
            try {
                SqlGenerator sqlGenerator = new SqlGenerator(this.getFactory());
                sqlGenerator.whereClause(whereClause);
                userWhereClause = sqlGenerator.getSQL().substring(7);
                this.idSelectParameterSpecifications = sqlGenerator.getCollectedParameters();
            }
            catch (RecognitionException e) {
                throw new HibernateException("Unable to generate id select for DML operation", e);
            }
            if (whereJoinFragment.length() > 0) {
                whereJoinFragment = whereJoinFragment + " and ";
            }
        }
        select.setWhereClause(whereJoinFragment + userWhereClause);
        InsertSelect insert = new InsertSelect(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert-select for " + persister.getEntityName() + " ids");
        }
        insert.setTableName(persister.getTemporaryIdTableName());
        insert.setSelect(select);
        return insert.toStatementString();
    }

    protected String generateIdSubselect(Queryable persister) {
        return "select " + StringHelper.join(", ", persister.getIdentifierColumnNames()) + " from " + persister.getTemporaryIdTableName();
    }

    protected void createTemporaryTableIfNecessary(final Queryable persister, SessionImplementor session) {
        IsolatedWork work = new IsolatedWork(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void doWork(Connection connection) throws HibernateException {
                Statement stmnt = null;
                stmnt = connection.createStatement();
                stmnt.executeUpdate(persister.getTemporaryIdTableDDL());
                Object var5_3 = null;
                if (stmnt == null) return;
                try {
                    stmnt.close();
                    return;
                }
                catch (Throwable ignore) {}
                return;
                {
                    catch (Throwable t) {
                        AbstractStatementExecutor.this.log.debug("unable to create temporary id table [" + t.getMessage() + "]");
                        Object var5_4 = null;
                        if (stmnt == null) return;
                        try {
                            stmnt.close();
                            return;
                        }
                        catch (Throwable ignore) {}
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (stmnt == null) throw throwable;
                    try {
                        stmnt.close();
                        throw throwable;
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        };
        if (this.shouldIsolateTemporaryTableDDL()) {
            if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                Isolater.doIsolatedWork(work, session);
            } else {
                Isolater.doNonTransactedWork(work, session);
            }
        } else {
            work.doWork(session.getJDBCContext().getConnectionManager().getConnection());
            session.getJDBCContext().getConnectionManager().afterStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dropTemporaryTableIfNecessary(final Queryable persister, final SessionImplementor session) {
        PreparedStatement ps;
        if (this.getFactory().getDialect().dropTemporaryTableAfterUse()) {
            IsolatedWork work = new IsolatedWork(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void doWork(Connection connection) throws HibernateException {
                    Statement stmnt = null;
                    String command = session.getFactory().getSettings().getDialect().getDropTemporaryTableString() + " " + persister.getTemporaryIdTableName();
                    stmnt = connection.createStatement();
                    stmnt.executeUpdate(command);
                    Object var5_5 = null;
                    if (stmnt == null) return;
                    try {
                        stmnt.close();
                        return;
                    }
                    catch (Throwable ignore) {}
                    return;
                    {
                        catch (Throwable t) {
                            AbstractStatementExecutor.this.log.warn("unable to drop temporary id table after use [" + t.getMessage() + "]");
                            Object var5_6 = null;
                            if (stmnt == null) return;
                            try {
                                stmnt.close();
                                return;
                            }
                            catch (Throwable ignore) {}
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        if (stmnt == null) throw throwable;
                        try {
                            stmnt.close();
                            throw throwable;
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            };
            if (this.shouldIsolateTemporaryTableDDL()) {
                if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                    Isolater.doIsolatedWork(work, session);
                    return;
                } else {
                    Isolater.doNonTransactedWork(work, session);
                }
                return;
            } else {
                work.doWork(session.getJDBCContext().getConnectionManager().getConnection());
                session.getJDBCContext().getConnectionManager().afterStatement();
            }
            return;
        } else {
            ps = null;
            ps = session.getBatcher().prepareStatement("delete from " + persister.getTemporaryIdTableName());
            ps.executeUpdate();
            Object var6_5 = null;
            if (ps == null) return;
            try {
                session.getBatcher().closeStatement(ps);
                return;
            }
            catch (Throwable ignore) {}
        }
        return;
        {
            catch (Throwable t) {
                this.log.warn("unable to cleanup temporary id table after use [" + t + "]");
                Object var6_6 = null;
                if (ps == null) return;
                try {
                    session.getBatcher().closeStatement(ps);
                    return;
                }
                catch (Throwable ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (ps == null) throw throwable;
            try {
                session.getBatcher().closeStatement(ps);
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor session) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.getAffectedQueryables());
        action.init();
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        }
    }

    protected boolean shouldIsolateTemporaryTableDDL() {
        Boolean dialectVote = this.getFactory().getDialect().performTemporaryTableDDLInIsolation();
        if (dialectVote != null) {
            return dialectVote;
        }
        return this.getFactory().getSettings().isDataDefinitionImplicitCommit();
    }
}

