/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;

public class FlushCloseOpenTest
extends ChannelTestBase {
    public FlushCloseOpenTest() {
    }

    public FlushCloseOpenTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public void testAndLoop() throws Exception {
        ClusterSrv srv1 = new ClusterSrv();
        ClusterSrv srv2 = new ClusterSrv();
        for (int i = 1; i < 10; ++i) {
            srv1.start();
            srv2.start();
            srv1.sendMessage((Serializable)((Object)"msg1"));
            srv2.sendMessage((Serializable)((Object)"msg2"));
            srv1.flush();
            this.assertCount(srv1, 2, srv2, 2);
            srv1.stopFlush();
            srv1.stop();
            srv1.start();
            srv2.sendMessage((Serializable)((Object)"msg3"));
            srv2.flush();
            this.assertCount(srv1, 3, srv2, 3);
            srv2.stopFlush();
            srv2.stop();
            srv2.start();
            srv2.sendMessage((Serializable)((Object)"msg4"));
            srv2.flush();
            srv2.stopFlush();
            this.assertCount(srv1, 4, srv2, 4);
            srv1.stop();
            srv2.stop();
            srv1.receiveCount.set(0L);
            srv2.receiveCount.set(0L);
            System.out.println("***** Round " + i + " done *****");
        }
    }

    private void assertCount(ClusterSrv srv1, int srv1Count, ClusterSrv srv2, int srv2Count) throws InterruptedException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000 && (srv1.receiveCount.get() != (long)srv1Count || srv2.receiveCount.get() != (long)srv2Count); ++i) {
            Thread.sleep(10L);
        }
        FlushCloseOpenTest.assertEquals((long)srv1Count, (long)srv1.receiveCount.get());
        FlushCloseOpenTest.assertEquals((long)srv2Count, (long)srv2.receiveCount.get());
        this.log.info((Object)("assert OK in " + (System.currentTimeMillis() - start) + "ms"));
    }

    private class ClusterSrv {
        private JChannel channel;
        public final AtomicLong receiveCount = new AtomicLong();
        public ReceiverImpl receiver;

        private ClusterSrv() {
        }

        private synchronized void start() throws ChannelException, IOException {
            long start = System.currentTimeMillis();
            this.channel = new JChannel(ChannelTestBase.CHANNEL_CONFIG);
            this.receiver = new ReceiverImpl();
            this.channel.setReceiver(this.receiver);
            this.channel.connect("testClust");
            this.notifyAll();
            FlushCloseOpenTest.this.log.info((Object)("Start done in " + (System.currentTimeMillis() - start) + " ms"));
        }

        public void flush() {
            this.channel.startFlush(false);
        }

        public void stopFlush() {
            this.channel.stopFlush();
        }

        private synchronized void stop() {
            this.channel.close();
        }

        private synchronized void sendMessage(Serializable obj) throws Exception {
            if (!this.channel.isConnected()) {
                FlushCloseOpenTest.this.log.warn((Object)"Channel disconnected in send, discarding msg");
                return;
            }
            Message msg = new Message(null, null, obj);
            FlushCloseOpenTest.this.log.debug((Object)("Sending message: " + msg));
            this.channel.send(msg);
            FlushCloseOpenTest.this.log.debug((Object)("Sent message: " + msg));
        }

        private class ReceiverImpl
        extends ReceiverAdapter {
            final List<Object> msgs = new ArrayList<Object>();

            private ReceiverImpl() {
            }

            public List<Object> getMsgs() {
                return this.msgs;
            }

            @Override
            public void receive(Message msg) {
                try {
                    Object data = msg.getObject();
                    this.msgs.add(data);
                    ClusterSrv.this.receiveCount.incrementAndGet();
                    FlushCloseOpenTest.this.log.debug((Object)("Received msg: " + data));
                }
                catch (Exception e) {
                    FlushCloseOpenTest.this.log.error((Object)"Receive failed", (Throwable)e);
                }
            }

            @Override
            public void viewAccepted(View new_view) {
            }
        }
    }
}

