/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.ThreadDecorator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadManager;

public class TimeScheduler
extends ScheduledThreadPoolExecutor
implements ThreadManager {
    private static int TIMER_DEFAULT_NUM_THREADS = 3;
    protected static final Log log = LogFactory.getLog(TimeScheduler.class);
    private ThreadDecorator threadDecorator = null;

    public TimeScheduler() {
        this(TIMER_DEFAULT_NUM_THREADS);
    }

    public TimeScheduler(ThreadFactory factory) {
        this(factory, TIMER_DEFAULT_NUM_THREADS);
    }

    public TimeScheduler(ThreadFactory factory, int max_threads) {
        super(max_threads, factory);
        this.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(this.getRejectedExecutionHandler()));
    }

    public TimeScheduler(int corePoolSize) {
        super(corePoolSize);
        this.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(this.getRejectedExecutionHandler()));
    }

    @Override
    public ThreadDecorator getThreadDecorator() {
        return this.threadDecorator;
    }

    @Override
    public void setThreadDecorator(ThreadDecorator threadDecorator) {
        this.threadDecorator = threadDecorator;
    }

    public String dumpTaskQueue() {
        return this.getQueue().toString();
    }

    public ScheduledFuture<?> scheduleWithDynamicInterval(Task task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        TaskWrapper task_wrapper = new TaskWrapper(task);
        task_wrapper.doSchedule();
        return task_wrapper;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new RobustRunnable(command), initialDelay, delay, unit);
    }

    public int size() {
        return this.getQueue().size();
    }

    public void stop() throws InterruptedException {
        List<Runnable> tasks = this.shutdownNow();
        for (Runnable task : tasks) {
            if (!(task instanceof Future)) continue;
            Future future = (Future)((Object)task);
            future.cancel(true);
        }
        this.getQueue().clear();
        this.awaitTermination(3000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            if (this.threadDecorator != null) {
                this.threadDecorator.threadReleased(Thread.currentThread());
            }
        }
    }

    static {
        try {
            String tmp = System.getProperty("jgroups.timer.num_threads");
            if (tmp != null) {
                TIMER_DEFAULT_NUM_THREADS = Integer.parseInt(tmp);
            }
        }
        catch (Exception e) {
            log.error((Object)"could not set number of timer threads", (Throwable)e);
        }
    }

    private class TaskWrapper<V>
    implements Runnable,
    ScheduledFuture<V> {
        private final Task task;
        private volatile ScheduledFuture<?> future;
        private volatile boolean cancelled = false;

        public TaskWrapper(Task task) {
            this.task = task;
        }

        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        @Override
        public void run() {
            try {
                if (this.cancelled) {
                    if (this.future != null) {
                        this.future.cancel(true);
                    }
                    return;
                }
                if (this.future != null && this.future.isCancelled()) {
                    return;
                }
                this.task.run();
            }
            catch (Throwable t) {
                log.error((Object)("failed running task " + this.task), t);
            }
            if (this.cancelled) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
                return;
            }
            if (this.future != null && this.future.isCancelled()) {
                return;
            }
            this.doSchedule();
        }

        public void doSchedule() {
            long next_interval = this.task.nextInterval();
            if (next_interval <= 0L) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("task will not get rescheduled as interval is " + next_interval));
                }
            } else {
                this.future = TimeScheduler.this.schedule(this, next_interval, TimeUnit.MILLISECONDS);
                if (this.cancelled) {
                    this.future.cancel(true);
                }
            }
        }

        @Override
        public int compareTo(Delayed o) {
            long their_delay;
            long my_delay = this.future.getDelay(TimeUnit.MILLISECONDS);
            return my_delay < (their_delay = o.getDelay(TimeUnit.MILLISECONDS)) ? -1 : (my_delay > their_delay ? 1 : 0);
        }

        public boolean equals(Object obj) {
            Delayed other = (Delayed)obj;
            return this.compareTo(other) == 0;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.future != null ? this.future.getDelay(unit) : -1L;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(mayInterruptIfRunning);
            }
            return this.cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled || this.future != null && this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future == null || this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }

    static class RobustRunnable
    implements Runnable {
        final Runnable command;

        public RobustRunnable(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            block3: {
                if (this.command != null) {
                    try {
                        this.command.run();
                    }
                    catch (Throwable t) {
                        if (!log.isErrorEnabled()) break block3;
                        log.error((Object)("exception executing task " + this.command), t);
                    }
                }
            }
        }
    }

    public static interface Task
    extends Runnable {
        public long nextInterval();
    }
}

