/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.pseudoserver.HttpRequest;
import com.meterware.pseudoserver.HttpResponseStream;
import com.meterware.pseudoserver.PseudoServlet;
import com.meterware.pseudoserver.ServerSocketFactory;
import com.meterware.pseudoserver.UnknownMethodException;
import com.meterware.pseudoserver.WebResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PseudoServer {
    private static final int DEFAULT_SOCKET_TIMEOUT = 1000;
    private static final int INPUT_POLL_INTERVAL = 10;
    private static int _socketReleaseWaitTime = 50;
    private static int _waitThreshhold = 10;
    private static int _numServers = 0;
    private int _serverNum = 0;
    private int _connectionNum = 0;
    private ArrayList _classpathDirs = new ArrayList();
    private String _maxProtocolLevel = "1.1";
    private final int _socketTimeout;
    private Hashtable _resources = new Hashtable();
    private boolean _active = true;
    private boolean _debug;
    private ServerSocket _serverSocket;

    public static int getSocketReleaseWaitTime() {
        return _socketReleaseWaitTime;
    }

    public static void setSocketReleaseWaitTime(int socketReleaseWaitTime) {
        _socketReleaseWaitTime = socketReleaseWaitTime;
    }

    public static int getWaitThreshhold() {
        return _waitThreshhold;
    }

    public static void setWaitThreshhold(int waitThreshhold) {
        _waitThreshhold = waitThreshhold;
    }

    public PseudoServer() {
        this(1000);
    }

    public PseudoServer(int socketTimeout) {
        this._socketTimeout = socketTimeout;
        this._serverNum = ++_numServers;
        Thread t = new Thread("PseudoServer " + this._serverNum){

            @Override
            public void run() {
                while (PseudoServer.this._active) {
                    try {
                        PseudoServer.this.handleNewConnection(PseudoServer.this.getServerSocket().accept());
                        Thread.sleep(20L);
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        System.out.println("Error in pseudo server: " + e);
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted. Shutting down");
                        PseudoServer.this._active = false;
                    }
                }
                try {
                    if (PseudoServer.this._serverSocket != null) {
                        ServerSocketFactory.release(PseudoServer.this._serverSocket);
                    }
                    PseudoServer.this._serverSocket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    public void shutDown() {
        if (this._debug) {
            System.out.println("** Requested shutdown of pseudoserver: " + this.hashCode());
        }
        this._active = false;
    }

    public void setMaxProtocolLevel(int majorLevel, int minorLevel) {
        this._maxProtocolLevel = majorLevel + "." + minorLevel;
    }

    public int getConnectedPort() throws IOException {
        return this.getServerSocket().getLocalPort();
    }

    public void setResource(String name, String value) {
        this.setResource(name, value, "text/html");
    }

    public void setResource(String name, PseudoServlet servlet) {
        this._resources.put(this.asResourceName(name), servlet);
    }

    public void setResource(String name, String value, String contentType) {
        this._resources.put(this.asResourceName(name), new WebResource(value, contentType));
    }

    public void setResource(String name, byte[] value, String contentType) {
        this._resources.put(this.asResourceName(name), new WebResource(value, contentType));
    }

    public void setErrorResource(String name, int errorCode, String errorMessage) {
        this._resources.put(this.asResourceName(name), new WebResource(errorMessage, errorCode));
    }

    public void setSendCharacterSet(String name, boolean enabled) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            throw new IllegalArgumentException("No defined resource " + name);
        }
        resource.setSendCharacterSet(enabled);
    }

    public void setCharacterSet(String name, String characterSet) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            resource = new WebResource("");
            this._resources.put(this.asResourceName(name), resource);
        }
        resource.setCharacterSet(characterSet);
    }

    public void addResourceHeader(String name, String header) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            resource = new WebResource("");
            this._resources.put(this.asResourceName(name), resource);
        }
        resource.addHeader(header);
    }

    public void mapToClasspath(String directory) {
        this._classpathDirs.add(directory);
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    private String asResourceName(String rawName) {
        if (rawName.startsWith("http:") || rawName.startsWith("/")) {
            return PseudoServer.escape(rawName);
        }
        return PseudoServer.escape("/" + rawName);
    }

    private static String escape(String urlString) {
        if (urlString.indexOf(32) < 0) {
            return urlString;
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while (true) {
            int index;
            if ((index = urlString.indexOf(32, start)) < 0) break;
            sb.append(urlString.substring(start, index)).append("%20");
            start = index + 1;
        }
        sb.append(urlString.substring(start));
        return sb.toString();
    }

    private void handleNewConnection(final Socket socket) {
        Thread t = new Thread("PseudoServer " + this._serverNum + " connection " + ++this._connectionNum){

            @Override
            public void run() {
                try {
                    PseudoServer.this.serveRequests(socket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void serveRequests(Socket socket) throws IOException {
        HttpRequest request;
        boolean keepAlive;
        socket.setSoTimeout(this._socketTimeout);
        socket.setTcpNoDelay(true);
        if (this._debug) {
            System.out.println("** Created server thread: " + this.hashCode());
        }
        BufferedInputStream inputStream = new BufferedInputStream(socket.getInputStream());
        HttpResponseStream outputStream = new HttpResponseStream(socket.getOutputStream());
        while (this._active && (keepAlive = this.respondToRequest(request = new HttpRequest(inputStream), outputStream))) {
            while (this._active && 0 == inputStream.available()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
        }
        if (this._debug) {
            System.out.println("** Closing server thread: " + this.hashCode());
        }
        outputStream.close();
        socket.close();
    }

    private boolean respondToRequest(HttpRequest request, HttpResponseStream response) {
        if (this._debug) {
            System.out.println("** Server thread " + this.hashCode() + " handling request: " + request);
        }
        boolean keepAlive = this.isKeepAlive(request);
        WebResource resource = null;
        try {
            response.restart();
            response.setProtocol(this.getResponseProtocol(request));
            resource = this.getResource(request);
            if (resource == null) {
                response.setResponse(404, "unable to find " + request.getURI());
            } else {
                if (resource.closesConnection()) {
                    keepAlive = false;
                }
                if (resource.getResponseCode() != 200) {
                    response.setResponse(resource.getResponseCode(), "");
                }
                String[] headers = resource.getHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    if (this._debug) {
                        System.out.println("** Server thread " + this.hashCode() + " sending header: " + headers[i]);
                    }
                    response.addHeader(headers[i]);
                }
            }
        }
        catch (UnknownMethodException e) {
            response.setResponse(405, "unsupported method: " + e.getMethod());
        }
        catch (Throwable t) {
            t.printStackTrace();
            response.setResponse(500, t.toString());
        }
        try {
            response.write(resource);
        }
        catch (IOException e) {
            System.out.println("*** Failed to send reply: " + e);
        }
        return keepAlive;
    }

    private boolean isKeepAlive(HttpRequest request) {
        return request.wantsKeepAlive() && this._maxProtocolLevel.equals("1.1");
    }

    private String getResponseProtocol(HttpRequest request) {
        return this._maxProtocolLevel.equalsIgnoreCase("1.1") ? request.getProtocol() : "HTTP/1.0";
    }

    private WebResource getResource(HttpRequest request) throws IOException {
        Object resource = this._resources.get(request.getURI());
        if (resource == null) {
            resource = this._resources.get(this.withoutParameters(request.getURI()));
        }
        if (request.getCommand().equals("GET") && resource instanceof WebResource) {
            return (WebResource)resource;
        }
        if (resource instanceof PseudoServlet) {
            return this.getResource((PseudoServlet)resource, request);
        }
        if (request.getURI().endsWith(".class")) {
            for (String directory : this._classpathDirs) {
                if (!request.getURI().startsWith(directory)) continue;
                String resourceName = request.getURI().substring(directory.length() + 1);
                return new WebResource(this.getClass().getClassLoader().getResourceAsStream(resourceName), "application/class", 200);
            }
            return null;
        }
        if (request.getURI().endsWith(".zip") || request.getURI().endsWith(".jar")) {
            for (String directory : this._classpathDirs) {
                if (!request.getURI().startsWith(directory)) continue;
                String resourceName = request.getURI().substring(directory.length() + 1);
                String classPath = System.getProperty("java.class.path");
                StringTokenizer st = new StringTokenizer(classPath, ":;,");
                while (st.hasMoreTokens()) {
                    String file = st.nextToken();
                    if (!file.endsWith(resourceName)) continue;
                    File f = new File(file);
                    return new WebResource(new FileInputStream(f), "application/zip", 200);
                }
            }
            return null;
        }
        return null;
    }

    private String withoutParameters(String uri) {
        return uri.indexOf(63) < 0 ? uri : uri.substring(0, uri.indexOf(63));
    }

    private WebResource getResource(PseudoServlet servlet, HttpRequest request) throws IOException {
        servlet.init(request);
        return servlet.getResponse(request.getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerSocket getServerSocket() throws IOException {
        PseudoServer pseudoServer = this;
        synchronized (pseudoServer) {
            if (this._serverSocket == null) {
                this._serverSocket = ServerSocketFactory.newServerSocket();
            }
        }
        return this._serverSocket;
    }
}

