/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import java.util.ArrayList;
import java.util.List;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.server.selector.Selector;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.Queue;

public class ManagedQueue
extends ManagedDestination {
    private static final Logger log = Logger.getLogger(ManagedQueue.class);
    private static boolean trace = log.isTraceEnabled();
    private MessageCounter messageCounter;
    private Queue queue;
    private int deliveringCounterLevel = 1;

    public ManagedQueue() {
    }

    public ManagedQueue(String name, int fullSize, int pageSize, int downCacheSize, boolean clustered) {
        super(name, fullSize, pageSize, downCacheSize, clustered);
    }

    public boolean isQueue() {
        return true;
    }

    public void setMessageCounterHistoryDayLimit(int limit) throws Exception {
        super.setMessageCounterHistoryDayLimit(limit);
        if (this.messageCounter != null) {
            this.messageCounter.setHistoryLimit(limit);
        }
    }

    public int getMessageCount() throws Exception {
        int count = this.queue.getMessageCount();
        if (trace) {
            log.trace((Object)(this + " returning MessageCount = " + count));
        }
        return count;
    }

    public int getDeliveringCount() throws Exception {
        int count = this.queue.getDeliveringCount();
        if (trace) {
            log.trace((Object)(this + " returning DeliveringCount = " + count));
        }
        return count;
    }

    public int getDeliveringCounterLevel() {
        return this.deliveringCounterLevel;
    }

    public void setDeliveringCounterLevel(int level) {
        this.deliveringCounterLevel = level;
    }

    public int getScheduledMessageCount() throws Exception {
        int count = this.queue.getScheduledCount();
        if (trace) {
            log.trace((Object)(this + " returning ScheduledMessageCount = " + count));
        }
        return count;
    }

    public int getConsumersCount() throws Exception {
        int count = this.queue.getLocalDistributor().getNumberOfReceivers();
        if (trace) {
            log.trace((Object)(this + " returning ConsumersCount = " + count));
        }
        return count;
    }

    public void removeAllMessages() throws Throwable {
        this.queue.removeAllReferences();
    }

    public List listAllMessages(String selector) throws Exception {
        return this.listMessages(0, selector);
    }

    public List listInProcessMessages() throws Exception {
        return this.queue.listInProcessMessages();
    }

    public List listDurableMessages(String selector) throws Exception {
        return this.listMessages(1, selector);
    }

    public List listNonDurableMessages(String selector) throws Exception {
        return this.listMessages(2, selector);
    }

    private List listMessages(int type, String selector) throws Exception {
        Selector sel = null;
        if (selector != null && "".equals(selector.trim())) {
            selector = null;
        }
        if (selector != null) {
            sel = new Selector(selector);
        }
        ArrayList<Message> msgs = new ArrayList<Message>();
        List allMsgs = this.queue.browse(sel);
        for (Message msg : allMsgs) {
            if (type != 0 && (type != 1 || !msg.isReliable()) && (type != 2 || msg.isReliable())) continue;
            msgs.add(msg);
        }
        return msgs;
    }

    public MessageCounter getMessageCounter() {
        return this.messageCounter;
    }

    public void setMessageCounter(MessageCounter counter) {
        this.messageCounter = counter;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public String toString() {
        return "ManagedQueue[" + this.name + "]";
    }
}

