/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.tx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.impl.tx.TransactionException;
import org.jboss.messaging.core.impl.tx.TransactionRepository;
import org.jboss.messaging.core.impl.tx.TxCallback;
import org.jboss.messaging.core.impl.tx.TxCallbackEx;

public class Transaction {
    private static final Logger log = Logger.getLogger(Transaction.class);
    private boolean trace = log.isTraceEnabled();
    private long id;
    private int state;
    private Xid xid;
    private List callbacks;
    private Map callbackMap;
    private boolean recoveredFromStorage;
    private long creationTime;
    protected TransactionRepository repository;
    protected TxCallback firstCallback;
    public static final int STATE_ACTIVE = 0;
    public static final int STATE_PREPARED = 1;
    public static final int STATE_COMMITTED = 2;
    public static final int STATE_ROLLEDBACK = 3;
    public static final int STATE_ROLLBACK_ONLY = 4;

    public static String stateToString(int state) {
        if (state == 0) {
            return "ACTIVE";
        }
        if (state == 1) {
            return "PREPARED";
        }
        if (state == 2) {
            return "COMMITTED";
        }
        if (state == 3) {
            return "ROLLEDBACK";
        }
        if (state == 4) {
            return "ROLLBACK_ONLY";
        }
        return "UNKNOWN";
    }

    Transaction(long id) {
        this.id = id;
        this.state = 0;
        this.callbacks = new ArrayList();
        this.callbackMap = new HashMap();
        this.creationTime = System.currentTimeMillis();
    }

    Transaction(long id, Xid xid, TransactionRepository tr) {
        this(id);
        this.xid = xid;
        this.repository = tr;
    }

    Transaction(long id, Xid xid, TransactionRepository tr, long ct) {
        this(id, xid, tr);
        this.creationTime = ct;
    }

    public int getState() {
        return this.state;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void addCallback(TxCallback callback, Object key) {
        this.callbacks.add(callback);
        this.callbackMap.put(key, callback);
    }

    public void addFirstCallback(TxCallback callback, Object key) {
        if (this.firstCallback != null) {
            throw new IllegalStateException("There is already a first callback");
        }
        this.firstCallback = callback;
        this.callbackMap.put(key, callback);
    }

    public TxCallback getCallback(Object key) {
        return (TxCallback)this.callbackMap.get(key);
    }

    public synchronized void commit() throws Exception {
        if (this.state == 4) {
            throw new TransactionException("Transaction marked rollback only, cannot commit");
        }
        if (this.state == 2) {
            throw new TransactionException("Transaction already committed, cannot commit");
        }
        if (this.state == 3) {
            throw new TransactionException("Transaction already rolled back, cannot commit");
        }
        if (this.recoveredFromStorage) {
            this.loadState();
        }
        if (this.trace) {
            log.trace((Object)(this + " executing before commit hooks"));
        }
        boolean onePhase = this.state != 1;
        Iterator iter = null;
        try {
            if (this.firstCallback != null) {
                this.firstCallback.beforeCommit(onePhase);
            }
            for (TxCallback callback : this.callbacks) {
                callback.beforeCommit(onePhase);
            }
            this.state = 2;
            if (this.trace) {
                log.trace((Object)(this + " committed"));
            }
        }
        catch (Exception e) {
            if (onePhase) {
                if (this.trace) {
                    log.trace((Object)(this + " one-phase commit results in rollback."));
                }
                this.rollback();
                throw new XAException(104);
            }
            throw e;
        }
        iter = this.callbacks.iterator();
        if (this.trace) {
            log.trace((Object)(this + " executing after commit hooks"));
        }
        if (this.firstCallback != null) {
            this.firstCallback.afterCommit(onePhase);
        }
        while (iter.hasNext()) {
            TxCallback callback;
            callback = (TxCallback)iter.next();
            callback.afterCommit(onePhase);
        }
        this.callbacks = null;
        this.callbackMap = null;
        this.firstCallback = null;
        if (this.repository != null) {
            this.repository.deleteTransaction(this);
        }
        if (this.trace) {
            log.trace((Object)(this + " commit process complete"));
        }
    }

    public synchronized void prepare() throws Exception {
        if (this.state != 0) {
            throw new TransactionException("Transaction not active, cannot prepare");
        }
        if (this.trace) {
            log.trace((Object)(this + " executing before prepare hooks"));
        }
        if (this.firstCallback != null) {
            this.firstCallback.beforePrepare();
        }
        for (TxCallback callback : this.callbacks) {
            callback.beforePrepare();
        }
        this.state = 1;
        if (this.trace) {
            log.trace((Object)(this + " prepared"));
        }
        if (this.firstCallback != null) {
            this.firstCallback.afterPrepare();
        }
        Iterator iter = this.callbacks.iterator();
        if (this.trace) {
            log.trace((Object)(this + " executing after prepare hooks"));
        }
        while (iter.hasNext()) {
            TxCallback callback;
            callback = (TxCallback)iter.next();
            callback.afterPrepare();
        }
        if (this.trace) {
            log.trace((Object)(this + " prepare process complete"));
        }
    }

    public void rollback() throws Exception {
        this.rollback(false);
    }

    public synchronized void rollback(boolean recovered) throws Exception {
        boolean onePhase;
        if (this.state == 2) {
            throw new TransactionException("Transaction already committed, cannot rollback");
        }
        if (this.state == 3) {
            throw new TransactionException("Transaction already rolled back, cannot rollback");
        }
        if (this.recoveredFromStorage) {
            this.loadState();
        }
        if (this.trace) {
            log.trace((Object)(this + " executing before rollback hooks"));
        }
        boolean bl = onePhase = this.state != 1;
        if (this.firstCallback != null) {
            this.firstCallback.beforeRollback(onePhase);
        }
        for (TxCallback callback : this.callbacks) {
            callback.beforeRollback(onePhase);
        }
        this.state = 3;
        if (this.trace) {
            log.trace((Object)(this + " rolled back"));
        }
        if (this.trace) {
            log.trace((Object)(this + " executing after rollback hooks"));
        }
        if (this.firstCallback != null) {
            this.firstCallback.afterRollback(onePhase);
        }
        for (TxCallback callback : this.callbacks) {
            if (callback instanceof TxCallbackEx) {
                ((TxCallbackEx)callback).afterRollbackEx(onePhase, recovered || onePhase);
                continue;
            }
            callback.afterRollback(onePhase);
        }
        this.callbacks = null;
        this.callbackMap = null;
        if (this.repository != null) {
            this.repository.deleteTransaction(this);
        }
        if (this.trace) {
            log.trace((Object)(this + " rollback process complete"));
        }
    }

    public void loadState() throws Exception {
        this.repository.handleReferences(this);
        this.repository.handleAcks(this);
        this.recoveredFromStorage = false;
    }

    public synchronized void setRollbackOnly() throws Exception {
        if (this.trace) {
            log.trace((Object)("setting ROLLBACK_ONLY on " + this));
        }
        this.state = 4;
    }

    public long getId() {
        return this.id;
    }

    public boolean isRecoveredFromStorage() {
        return this.recoveredFromStorage;
    }

    public void setRecoveredFromStorage(boolean recoveredFromStorage) {
        this.recoveredFromStorage = recoveredFromStorage;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getAge() {
        if (this.creationTime == Long.MIN_VALUE) {
            return this.creationTime;
        }
        return System.currentTimeMillis() - this.creationTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TX(");
        sb.append(this.id);
        sb.append("):");
        sb.append(Transaction.stateToString(this.state));
        return sb.toString();
    }
}

