/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.MessageFlowRecord;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class ClusterConnectionBridge
extends BridgeImpl {
    private static final Logger log = Logger.getLogger(ClusterConnectionBridge.class);
    private final MessageFlowRecord flowRecord;
    private final SimpleString managementAddress;
    private final SimpleString managementNotificationAddress;
    private ClientConsumer notifConsumer;
    private final SimpleString idsHeaderName;
    private final TransportConfiguration connector;
    private final String targetNodeID;

    public ClusterConnectionBridge(ServerLocatorInternal serverLocator, UUID nodeUUID, String targetNodeID, SimpleString name, Queue queue, Executor executor, SimpleString filterString, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, Transformer transformer, boolean useDuplicateDetection, String user, String password, boolean activated, StorageManager storageManager, SimpleString managementAddress, SimpleString managementNotificationAddress, MessageFlowRecord flowRecord, TransportConfiguration connector) throws Exception {
        super(serverLocator, nodeUUID, name, queue, executor, filterString, forwardingAddress, scheduledExecutor, transformer, useDuplicateDetection, user, password, activated, storageManager);
        this.idsHeaderName = MessageImpl.HDR_ROUTE_TO_IDS.concat(name);
        this.targetNodeID = targetNodeID;
        this.managementAddress = managementAddress;
        this.managementNotificationAddress = managementNotificationAddress;
        this.flowRecord = flowRecord;
        this.connector = connector;
        queue.setInternalQueue(true);
    }

    @Override
    protected ServerMessage beforeForward(ServerMessage message) {
        message = message.copy();
        HashSet<SimpleString> propNames = new HashSet<SimpleString>(message.getPropertyNames());
        byte[] queueIds = message.getBytesProperty(this.idsHeaderName);
        for (SimpleString propName : propNames) {
            if (!propName.startsWith(MessageImpl.HDR_ROUTE_TO_IDS)) continue;
            message.removeProperty(propName);
        }
        message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, queueIds);
        message = super.beforeForward(message);
        return message;
    }

    private void setupNotificationConsumer() throws Exception {
        if (this.flowRecord != null) {
            this.flowRecord.reset();
            if (this.notifConsumer != null) {
                try {
                    this.notifConsumer.close();
                    this.notifConsumer = null;
                }
                catch (HornetQException e) {
                    log.error("Failed to close consumer", e);
                }
            }
            String qName = "notif." + UUIDGenerator.getInstance().generateStringUUID();
            SimpleString notifQueueName = new SimpleString(qName);
            SimpleString filter = new SimpleString(ManagementHelper.HDR_BINDING_TYPE + "<>" + BindingType.DIVERT.toInt() + " AND " + ManagementHelper.HDR_NOTIFICATION_TYPE + " IN ('" + (Object)((Object)NotificationType.BINDING_ADDED) + "','" + (Object)((Object)NotificationType.BINDING_REMOVED) + "','" + (Object)((Object)NotificationType.CONSUMER_CREATED) + "','" + (Object)((Object)NotificationType.CONSUMER_CLOSED) + "','" + (Object)((Object)NotificationType.PROPOSAL) + "','" + (Object)((Object)NotificationType.PROPOSAL_RESPONSE) + "') AND " + ManagementHelper.HDR_DISTANCE + "<" + this.flowRecord.getMaxHops() + " AND (" + ManagementHelper.HDR_ADDRESS + " LIKE '" + this.flowRecord.getAddress() + "%')");
            this.session.createQueue(this.managementNotificationAddress, notifQueueName, filter, false);
            this.notifConsumer = this.session.createConsumer(notifQueueName);
            this.notifConsumer.setMessageHandler(this.flowRecord);
            this.session.start();
            ClientMessage message = this.session.createMessage(false);
            ManagementHelper.putOperationInvocation(message, "core.server", "sendQueueInfoToQueue", notifQueueName.toString(), this.flowRecord.getAddress());
            ClientProducer prod = this.session.createProducer(this.managementAddress);
            prod.send(message);
        }
    }

    @Override
    protected void afterConnect() throws Exception {
        this.setupNotificationConsumer();
    }

    @Override
    protected ClientSessionFactory createSessionFactory() throws Exception {
        return this.serverLocator.createSessionFactory(this.connector);
    }

    @Override
    public void connectionFailed(HornetQException me, boolean failedOver) {
        if (!failedOver && !this.session.isClosed()) {
            try {
                this.session.cleanUp(true);
            }
            catch (Exception e) {
                log.warn("Unable to clean up the session after a connection failure", e);
            }
            this.serverLocator.notifyNodeDown(this.targetNodeID);
        }
        super.connectionFailed(me, failedOver);
    }
}

