/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeQuery;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLBindingFactory;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPHTTPBindingTest
extends TestCase
implements EntityResolver {
    private String path = "data/org/opensaml/test.jks";
    private String alias = "mykey";
    private String password = "opensaml";
    private String endpoint = "https://wayf.internet2.edu:8443/shibboleth-idp/AA";
    private String schemaContent = "<schema targetNamespace=\"urn:mace:shibboleth:1.0\" xmlns=\"http://www.w3.org/2001/XMLSchema\"><complexType name=\"AttributeValueType\" mixed=\"true\"><complexContent><extension base=\"anyType\"/></complexContent></complexType></schema>";

    public SOAPHTTPBindingTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(SOAPHTTPBindingTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Logger.getRootLogger().setLevel(Level.OFF);
        HashMap<String, SOAPHTTPBindingTest> map = new HashMap<String, SOAPHTTPBindingTest>();
        map.put("shibboleth.xsd", this);
        XML.parserPool.registerSchemas(map);
        SAMLConfig.instance().setProperty("org.opensaml.ssl.truststore", this.path);
        SAMLConfig.instance().setProperty("org.opensaml.ssl.truststore-pwd", this.password);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSOAPBinding() throws Exception {
        SAMLRequest r = new SAMLRequest(new SAMLAttributeQuery(new SAMLSubject(new SAMLNameIdentifier("test-handle", "urn:mace:inqueue:example.edu", "urn:mace:shibboleth:test:nameIdentifier"), null, null, null), null, null));
        SAMLBinding b = SAMLBindingFactory.getInstance("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        SAMLResponse r2 = b.send(this.endpoint, r, null);
        SOAPHTTPBindingTest.assertEquals((String)"Unable to obtain an affiliation attribute of member from SAML AA", (String)((SAMLAttribute)((SAMLAttributeStatement)((SAMLAssertion)r2.getAssertions().next()).getStatements().next()).getAttributes().next()).getValues().next().toString(), (String)"member");
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId.equals("shibboleth.xsd")) {
            return new InputSource(new ByteArrayInputStream(this.schemaContent.getBytes()));
        }
        return null;
    }
}

