/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class Java5SharedLatchImpl
extends ReentrantReadWriteLock
implements SharedLatch {
    private String name;
    private boolean noteLatch;
    private List readers;
    private boolean exclusiveOnly;
    static final /* synthetic */ boolean $assertionsDisabled;

    Java5SharedLatchImpl() {
        super(EnvironmentImpl.getFairLatches());
        if (!$assertionsDisabled && (this.readers = Collections.synchronizedList(new ArrayList())) == null) {
            throw new AssertionError();
        }
        this.exclusiveOnly = false;
    }

    public void setExclusiveOnly(boolean exclusiveOnly) {
        this.exclusiveOnly = exclusiveOnly;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean setNoteLatch(boolean noteLatch) {
        this.noteLatch = noteLatch;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusive() throws DatabaseException {
        try {
            if (this.isWriteLockedByCurrentThread()) {
                throw new LatchException(this.name + " already held");
            }
            this.writeLock().lock();
            if (!$assertionsDisabled && this.noteLatch && !this.noteLatch()) {
                throw new AssertionError();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
            throw throwable;
        }
        if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireExclusiveNoWait() throws DatabaseException {
        boolean bl;
        try {
            if (this.isWriteLockedByCurrentThread()) {
                throw new LatchException(this.name + " already held");
            }
            boolean ret = this.writeLock().tryLock();
            if (!$assertionsDisabled && this.noteLatch & ret && !this.noteLatch()) {
                throw new AssertionError();
            }
            bl = ret;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
            throw throwable;
        }
        if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
            throw new AssertionError();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShared() throws DatabaseException {
        if (this.exclusiveOnly) {
            this.acquireExclusive();
            return;
        }
        try {
            boolean assertionsEnabled = false;
            if (!$assertionsDisabled) {
                assertionsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (assertionsEnabled) {
                if (this.readers.add(Thread.currentThread())) {
                    this.readLock().lock();
                }
            } else {
                this.readLock().lock();
            }
            if (!$assertionsDisabled && this.noteLatch && !this.noteLatch()) {
                throw new AssertionError();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
            throw throwable;
        }
        if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
            throw new AssertionError();
        }
    }

    public boolean isOwner() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled && !this.exclusiveOnly) {
            return this.readers.contains(Thread.currentThread()) || this.isWriteLockedByCurrentThread();
        }
        return this.isWriteLockedByCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() throws LatchNotHeldException {
        block11: {
            block10: {
                try {
                    block9: {
                        try {
                            if (this.isWriteLockedByCurrentThread()) {
                                this.writeLock().unlock();
                                Object var3_1 = null;
                                if ($assertionsDisabled) return;
                                if (!this.noteLatch) return;
                                break block9;
                            }
                            if (this.exclusiveOnly) {
                                break block10;
                            }
                            boolean assertionsEnabled = false;
                            if (!$assertionsDisabled) {
                                assertionsEnabled = true;
                            }
                            if (assertionsEnabled) {
                                if (!this.readers.remove(Thread.currentThread())) throw new LatchNotHeldException(this.name + " not held");
                                this.readLock().unlock();
                                break block11;
                            } else {
                                this.readLock().unlock();
                            }
                            break block11;
                        }
                        catch (IllegalMonitorStateException IMSE) {
                            IMSE.printStackTrace();
                            Object var3_4 = null;
                            if ($assertionsDisabled) return;
                            if (!this.noteLatch) return;
                            if (!this.unNoteLatch()) throw new AssertionError();
                            return;
                        }
                    }
                    if (!this.unNoteLatch()) throw new AssertionError();
                    return;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if ($assertionsDisabled) throw throwable;
                    if (!this.noteLatch) throw throwable;
                    if (!this.unNoteLatch()) throw new AssertionError();
                    throw throwable;
                }
            }
            Object var3_2 = null;
            if ($assertionsDisabled) return;
            if (!this.noteLatch) return;
            if (!this.unNoteLatch()) throw new AssertionError();
            return;
        }
        Object var3_3 = null;
        if ($assertionsDisabled) return;
        if (!this.noteLatch) return;
        if (!this.unNoteLatch()) throw new AssertionError();
    }

    public void releaseIfOwner() throws LatchNotHeldException {
        Thread o = this.getOwner();
        if (this.isWriteLockedByCurrentThread()) {
            this.writeLock().unlock();
            if (!$assertionsDisabled && this.noteLatch && !this.unNoteLatch()) {
                throw new AssertionError();
            }
            return;
        }
        if (this.exclusiveOnly) {
            return;
        }
        if (!$assertionsDisabled && this.getReadLockCount() <= 0) {
            throw new AssertionError();
        }
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled) {
            if (this.readers.contains(Thread.currentThread())) {
                this.readLock().unlock();
                if (!$assertionsDisabled && this.noteLatch && !this.unNoteLatch()) {
                    throw new AssertionError();
                }
            }
        } else {
            this.readLock().unlock();
        }
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() {
        return LatchSupport.latchTable.unNoteLatch(this, this.name);
    }

    static {
        $assertionsDisabled = !Java5SharedLatchImpl.class.desiredAssertionStatus();
    }
}

