/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.generic.GenericBeanFactoryAccessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.handler.AbstractDetectingUrlHandlerMapping;
import org.springframework.web.servlet.mvc.annotation.ServletAnnotationMappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationHandlerMapping
extends AbstractDetectingUrlHandlerMapping {
    private boolean useDefaultSuffixPattern = true;
    private final Map<Class, RequestMapping> cachedMappings = new HashMap<Class, RequestMapping>();

    public void setUseDefaultSuffixPattern(boolean useDefaultSuffixPattern) {
        this.useDefaultSuffixPattern = useDefaultSuffixPattern;
    }

    @Override
    protected String[] determineUrlsForHandler(String beanName) {
        ApplicationContext context = this.getApplicationContext();
        Class handlerType = context.getType(beanName);
        Object bf = context instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)context).getBeanFactory() : context;
        GenericBeanFactoryAccessor bfa = new GenericBeanFactoryAccessor((ListableBeanFactory)bf);
        RequestMapping mapping = (RequestMapping)bfa.findAnnotationOnBean(beanName, RequestMapping.class);
        if (mapping != null) {
            this.cachedMappings.put(handlerType, mapping);
            LinkedHashSet<String> urls = new LinkedHashSet<String>();
            String[] paths = mapping.value();
            if (paths.length > 0) {
                for (String path : paths) {
                    this.addUrlsForPath(urls, path);
                }
                return StringUtils.toStringArray(urls);
            }
            return this.determineUrlsForHandlerMethods(handlerType);
        }
        if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) != null) {
            return this.determineUrlsForHandlerMethods(handlerType);
        }
        return null;
    }

    protected String[] determineUrlsForHandlerMethods(Class<?> handlerType) {
        final LinkedHashSet urls = new LinkedHashSet();
        ReflectionUtils.doWithMethods(handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                RequestMapping mapping = method.getAnnotation(RequestMapping.class);
                if (mapping != null) {
                    String[] mappedPaths = mapping.value();
                    for (int i = 0; i < mappedPaths.length; ++i) {
                        DefaultAnnotationHandlerMapping.this.addUrlsForPath(urls, mappedPaths[i]);
                    }
                }
            }
        });
        return StringUtils.toStringArray(urls);
    }

    protected void addUrlsForPath(Set<String> urls, String path) {
        urls.add(path);
        if (this.useDefaultSuffixPattern && path.indexOf(46) == -1) {
            urls.add(path + ".*");
        }
    }

    @Override
    protected void validateHandler(Object handler, HttpServletRequest request) throws Exception {
        RequestMapping mapping = this.cachedMappings.get(handler.getClass());
        if (mapping == null) {
            mapping = (RequestMapping)AnnotationUtils.findAnnotation(handler.getClass(), RequestMapping.class);
        }
        if (mapping != null) {
            this.validateMapping(mapping, request);
        }
    }

    protected void validateMapping(RequestMapping mapping, HttpServletRequest request) throws Exception {
        RequestMethod[] mappedMethods = mapping.method();
        if (!ServletAnnotationMappingUtils.checkRequestMethod(mappedMethods, request)) {
            String[] supportedMethods = new String[mappedMethods.length];
            for (int i = 0; i < mappedMethods.length; ++i) {
                supportedMethods[i] = mappedMethods[i].name();
            }
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), supportedMethods);
        }
        Object[] mappedParams = mapping.params();
        if (!ServletAnnotationMappingUtils.checkParameters((String[])mappedParams, request)) {
            throw new ServletException("Parameter conditions {" + StringUtils.arrayToDelimitedString((Object[])mappedParams, (String)", ") + "} not met for request parameters: " + request.getParameterMap());
        }
    }
}

