/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task.module;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Property;
import org.jboss.tools.buildmagic.task.AbstractBuildListener;
import org.jboss.tools.buildmagic.task.Ant;
import org.jboss.tools.buildmagic.task.ResolveProperties;
import org.jboss.tools.buildmagic.task.module.Module;
import org.jboss.tools.buildmagic.task.util.TaskLogger;
import org.jboss.util.Strings;

public class ExecuteModules
extends Task {
    protected final TaskLogger log = new TaskLogger(this);
    private String target;
    private String antfile;
    private List moduleNames;
    private String root;
    private List properties = new LinkedList();
    private Project internalProject;
    private String moduleProperty = "module";
    private String modulesReference = "modules";
    private String targetProperty = "target";
    private boolean skipMissing = false;
    private boolean inheritAll = false;
    private List headers = new LinkedList();
    private List footers = new LinkedList();
    private List beforeHooks = new LinkedList();
    private List afterHooks = new LinkedList();
    private ModuleBuildListener listener = new ModuleBuildListener();
    private List exportProperties = new LinkedList();
    private String module;
    private boolean threading = false;

    public void setThreading(boolean flag) {
        this.threading = flag;
    }

    public void setExportproperties(String list) {
        StringTokenizer stok = new StringTokenizer(list, ",");
        while (stok.hasMoreTokens()) {
            this.exportProperties.add(stok.nextToken().trim());
        }
    }

    public String getModulesReference() {
        return this.modulesReference;
    }

    public void setModulesReference(String modulesReference) {
        this.modulesReference = modulesReference;
    }

    public void setModuleproperty(String property) {
        this.moduleProperty = property;
    }

    public void setTargetproperty(String property) {
        this.targetProperty = property;
    }

    public void setInheritAll(boolean flag) {
        this.inheritAll = flag;
    }

    public void init() {
        this.internalProject = new Project();
        this.internalProject.setJavaVersionProperty();
        Hashtable tasks = this.getProject().getTaskDefinitions();
        this.internalProject.addTaskDefinition("property", (Class)tasks.get("property"));
        this.internalProject.addTaskDefinition("echo", (Class)tasks.get("echo"));
    }

    protected void reinit() {
        this.init();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property a = (Property)this.properties.get(i);
            Property b = (Property)this.internalProject.createTask("property");
            this.copy(a, b);
            this.properties.set(i, b);
        }
    }

    protected void copy(Property a, Property b) {
        b.setName(a.getName());
        if (a.getValue() != null) {
            b.setValue(a.getValue());
        }
        if (a.getFile() != null) {
            b.setFile(a.getFile());
        }
        if (a.getResource() != null) {
            b.setResource(a.getResource());
        }
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setAntfile(String antfile) {
        this.antfile = antfile;
    }

    public void setModules(String names) {
        names = ResolveProperties.subst(names, this.getProject(), true);
        StringTokenizer stok = new StringTokenizer(names, ",");
        this.moduleNames = new LinkedList();
        while (stok.hasMoreTokens()) {
            this.moduleNames.add(stok.nextToken().trim());
        }
    }

    public void setSkipmissing(boolean flag) {
        this.skipMissing = flag;
    }

    public void setRoot(String dir) throws BuildException {
        this.root = dir;
    }

    public void execute() throws BuildException {
        if (this.root == null) {
            throw new BuildException("Root directory not specified", this.getLocation());
        }
        List modules = (List)this.getProject().getReference(this.modulesReference);
        if (modules != null) {
            Iterator iter = modules.iterator();
            while (iter.hasNext()) {
                this.executeModule((Module)iter.next());
            }
        } else if (this.moduleNames != null) {
            Iterator iter = this.moduleNames.iterator();
            while (iter.hasNext()) {
                this.executeModule((String)iter.next(), false);
            }
        } else {
            throw new BuildException("No module names were specified", this.getLocation());
        }
    }

    public void executeModule(Module module) {
        this.executeModule(module.getName(), module.isExternalBuild());
    }

    public void executeModule(final String module, final boolean externalBuild) throws BuildException {
        Hashtable props;
        this.module = module;
        final Ant ant = (Ant)this.getProject().createTask("Ant");
        ant.setInheritAll(this.inheritAll);
        ant.init();
        this.internalProject.setProperty(this.moduleProperty, module);
        String tempTargetName = this.target == null ? "<default>" : this.target;
        this.evaluateExpression(tempTargetName);
        this.internalProject.setProperty(this.targetProperty, tempTargetName);
        ant.setLocation(this.getLocation());
        tempTargetName = ResolveProperties.subst(this.root, this.getProject());
        tempTargetName = Strings.subst((String)"@MODULE@", (String)module, (String)tempTargetName);
        tempTargetName = Strings.subst((String)"@TARGET@", (String)this.target, (String)tempTargetName);
        File moduleRoot = new File(tempTargetName);
        this.log.verbose("module root: " + moduleRoot);
        ant.setDir(moduleRoot);
        ant.setAntfile(this.antfile);
        if (this.target != null) {
            this.log.verbose("using target: " + this.target);
            ant.setTarget(this.target);
        }
        if ((props = this.getProject().getProperties()).get("ant.version").toString().contains("1.7")) {
            Property antVersion = ant.createProperty();
            antVersion.setName("ant.version");
            antVersion.setValue(props.get("ant.version").toString());
            antVersion.execute();
            Property antCoreLib = ant.createProperty();
            antCoreLib.setName("ant.core.lib");
            antCoreLib.setValue(props.get("ant.core.lib").toString());
            antCoreLib.execute();
        }
        try {
            ant.getBuildFile();
        }
        catch (BuildException e) {
            this.log.verbose("exception: " + (Object)((Object)e));
            if (this.skipMissing) {
                this.listener.skipped(module);
                this.log.warning("Missing build file; skipping module: " + module);
                props.remove(this.moduleProperty);
                props.remove(this.targetProperty);
                return;
            }
            this.log.error("Missing build file: " + module);
            throw e;
        }
        this.runHooks(this.beforeHooks);
        ant.addBuildListener(this.listener);
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            Property a = (Property)iter.next();
            Property b = ant.createProperty();
            this.copy(a, b);
            a.execute();
        }
        iter = this.exportProperties.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String value = (String)props.get(name);
            Property p = ant.createProperty();
            p.setName(name);
            p.setValue(value);
            this.log.verbose("Exported property " + name + "=" + value);
        }
        final String targetName = tempTargetName;
        Runnable runner = new Runnable(){

            public void run() {
                ExecuteModules.this.printMessages(ExecuteModules.this.headers);
                ExecuteModules.this.log.verbose("Executing " + targetName + " in module '" + module + "'...");
                if (externalBuild) {
                    Echo skipMessage = new Echo();
                    skipMessage.setProject(ExecuteModules.this.getProject());
                    skipMessage.setTaskName("echo");
                    skipMessage.setMessage("Skipping ant module build due to externalBuild setting.");
                    skipMessage.execute();
                } else {
                    ant.execute();
                }
                ExecuteModules.this.log.verbose("Finished with " + targetName + " in module '" + module + "'...");
                ExecuteModules.this.printMessages(ExecuteModules.this.footers);
                ExecuteModules.this.runHooks(ExecuteModules.this.afterHooks);
            }
        };
        if (this.threading) {
            new Thread(runner, "Module Runner (" + module + ":" + targetName + ")").start();
        } else {
            runner.run();
        }
    }

    protected void printMessages(List messages) {
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            MyEcho header = (MyEcho)((Object)iter.next());
            header.execute();
        }
    }

    public Property createProperty() {
        Property prop = this.createProperty(this.properties);
        return prop;
    }

    public Property createProperty(List list) {
        if (this.internalProject == null) {
            this.reinit();
        }
        Property prop = (Property)this.internalProject.createTask("property");
        if (list != null) {
            list.add(0, prop);
        }
        return prop;
    }

    public Echo createHeader() {
        if (this.internalProject == null) {
            this.reinit();
        }
        MyEcho header = new MyEcho(this.getProject());
        this.headers.add(header);
        return header;
    }

    public Echo createFooter() {
        if (this.internalProject == null) {
            this.reinit();
        }
        MyEcho footer = new MyEcho(this.getProject());
        this.footers.add(footer);
        return footer;
    }

    public String evaluateExpression(String expr) {
        Hashtable props = this.getProject().getUserProperties();
        expr = ResolveProperties.subst(expr, props, false);
        props = this.internalProject.getUserProperties();
        expr = ResolveProperties.subst(expr, props, false);
        props = this.internalProject.getProperties();
        expr = ResolveProperties.subst(expr, props, false);
        return expr;
    }

    public Hook createBefore() {
        Hook hook = new Hook(this);
        this.beforeHooks.add(hook);
        return hook;
    }

    public Hook createAfter() {
        Hook hook = new Hook(this);
        this.afterHooks.add(hook);
        return hook;
    }

    protected void runHooks(List list) throws BuildException {
        this.log.verbose("executing hooks");
        this.log.debug("list: " + list);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Hook hook = (Hook)iter.next();
            this.log.debug("executing hook: " + hook);
            hook.execute();
        }
    }

    protected class ModuleBuildListener
    extends AbstractBuildListener {
        protected ModuleBuildListener() {
        }

        public void skipped(String module) {
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            Throwable t = event.getException();
            int pri = event.getPriority();
            String message = event.getMessage();
            if (t != null) {
                // empty if block
            }
            switch (pri) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    protected class Hook {
        public ExecuteModules task;
        public String target;

        public Hook(ExecuteModules task) {
            this.task = task;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void execute() throws BuildException {
            Project project = this.task.getProject();
            String t = this.task.evaluateExpression(this.target);
            t = Strings.subst((String)"@MODULE@", (String)ExecuteModules.this.module, (String)t);
            t = Strings.subst((String)"@TARGET@", (String)ExecuteModules.this.target, (String)t);
            if (project.getTargets().containsKey(t)) {
                project.executeTarget(t);
            } else {
                ExecuteModules.this.log.verbose("skipping missing hook: " + t);
            }
        }
    }

    protected class MyEcho
    extends Echo {
        Project project;

        public MyEcho(Project project) {
            this.project = project;
        }

        public void addText(String msg) {
            this.message = this.message + msg;
        }

        public void execute() throws BuildException {
            String temp = ExecuteModules.this.evaluateExpression(this.message);
            temp = Strings.subst((String)"@MODULE@", (String)ExecuteModules.this.module, (String)temp);
            temp = Strings.subst((String)"@TARGET@", (String)ExecuteModules.this.target, (String)temp);
            this.project.log(temp, this.logLevel);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

