/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms.integration.mdb;

import java.util.Random;
import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.JBossTestSetup;
import org.jboss.test.jms.integration.MessagingIntegrationTestBase;
import org.jboss.test.jms.integration.mdb.MDBTestBase;
import org.jboss.test.jms.integration.support.ejb20.StatefulHome;
import org.jboss.test.jms.integration.support.ejb20.StatefulRemote;
import org.jboss.test.jms.integration.util.JMSAdmin;

public class TransactionedMDBTest
extends MDBTestBase {
    public TransactionedMDBTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransacioned() throws Exception {
        Connection conn = this.cf.createConnection();
        conn.start();
        Session sess = null;
        try {
            sess = conn.createSession(false, 1);
            MessageProducer producer = sess.createProducer(this.queueDestination);
            MessageConsumer consumer = sess.createConsumer(this.responseDestination);
            TextMessage message = sess.createTextMessage("Message " + this.random.nextLong());
            message.setJMSReplyTo(this.responseDestination);
            producer.send((Message)message);
            TextMessage messageResponse = (TextMessage)consumer.receive(10000L);
            TransactionedMDBTest.assertNotNull((Object)messageResponse);
            System.out.println("Received message " + messageResponse.getText());
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendFromEJB() throws Exception {
        Connection conn = this.cf.createConnection();
        conn.start();
        try {
            Session sess = conn.createSession(false, 1);
            MessageConsumer consumer = sess.createConsumer(this.responseDestination);
            InitialContext ctx = new InitialContext();
            StatefulHome home = (StatefulHome)ctx.lookup("ejb/StatefulTest");
            StatefulRemote remote = home.create();
            Random random = new Random();
            String msg = "Msgreturn " + random.nextLong();
            remote.sendTestMessage(msg);
            TextMessage receivedMessage = (TextMessage)consumer.receive(10000L);
            TransactionedMDBTest.assertNotNull((Object)receivedMessage);
            TransactionedMDBTest.assertEquals((String)msg, (String)receivedMessage.getText());
            remote.remove();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceiveOnEJB() throws Exception {
        Connection conn = this.cf.createConnection();
        try {
            Session sess = conn.createSession(false, 1);
            MessageProducer producer = sess.createProducer(this.responseDestination);
            Random random = new Random();
            String msg = "Msg " + random.nextLong();
            producer.send((Message)sess.createTextMessage(msg));
            InitialContext ctx = new InitialContext();
            StatefulHome home = (StatefulHome)ctx.lookup("ejb/StatefulTest");
            StatefulRemote remote = home.create();
            TransactionedMDBTest.assertEquals((String)msg, (String)remote.receiveMessage("queue/A_Integration", false, false));
            conn.start();
            MessageConsumer consumer = sess.createConsumer(this.responseDestination);
            TextMessage txtmsg = (TextMessage)consumer.receive(10000L);
            TransactionedMDBTest.assertNull((Object)txtmsg);
            System.out.println("return was " + txtmsg);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceiveOnEJBWithRollback() throws Exception {
        Connection conn = this.cf.createConnection();
        try {
            Session sess = conn.createSession(false, 1);
            MessageProducer producer = sess.createProducer(this.responseDestination);
            Random random = new Random();
            String msg = "Msg " + random.nextLong();
            producer.send((Message)sess.createTextMessage(msg));
            InitialContext ctx = new InitialContext();
            StatefulHome home = (StatefulHome)ctx.lookup("ejb/StatefulTest");
            StatefulRemote remote = home.create();
            TransactionedMDBTest.assertEquals((String)msg, (String)remote.receiveMessage("queue/A_Integration", true, false));
            conn.start();
            MessageConsumer consumer = sess.createConsumer(this.responseDestination);
            TextMessage txtmsg = (TextMessage)consumer.receive(10000L);
            TransactionedMDBTest.assertNotNull((Object)txtmsg);
            System.out.println("return was " + txtmsg + " with string=" + txtmsg.getText());
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceiveOnEJBWithCommit() throws Exception {
        Connection conn = this.cf.createConnection();
        try {
            Session sess = conn.createSession(false, 1);
            MessageProducer producer = sess.createProducer(this.responseDestination);
            Random random = new Random();
            String msg = "Msg " + random.nextLong();
            producer.send((Message)sess.createTextMessage(msg));
            InitialContext ctx = new InitialContext();
            StatefulHome home = (StatefulHome)ctx.lookup("ejb/StatefulTest");
            StatefulRemote remote = home.create();
            TransactionedMDBTest.assertEquals((String)msg, (String)remote.receiveMessage("queue/A_Integration", true, true));
            conn.start();
            MessageConsumer consumer = sess.createConsumer(this.responseDestination);
            TextMessage txtmsg = (TextMessage)consumer.receive(10000L);
            TransactionedMDBTest.assertNull((Object)txtmsg);
            System.out.println("return was " + txtmsg);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static Test suite() throws Exception {
        try {
            System.out.println("Test... Suite");
            Class.forName("org.jboss.invocation.InvokerInterceptor").newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new JBossTestSetup((Test)new TestSuite(TransactionedMDBTest.class)){

            protected void setUp() throws Exception {
                super.setUp();
                System.out.println("Hello");
                JMSAdmin admin = MessagingIntegrationTestBase.getDestManager();
                try {
                    admin.deployTopic("testTopic_Integration", "topic/testTopic_Integration");
                    admin.deployQueue("testQueue_Integration", "queue/testQueue_Integration");
                    admin.deployQueue("A_Integration", "queue/A_Integration");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.deploy("integration-mdb20-userTransaction.jar");
            }

            protected void tearDown() throws Exception {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                JMSAdmin admin = MessagingIntegrationTestBase.getDestManager();
                admin.destroyQueue("testQueue_Integration");
                admin.destroyTopic("testTopic_Integration");
                admin.destroyQueue("A_Integration");
                this.undeploy("integration-mdb20-userTransaction.jar");
                super.tearDown();
            }
        });
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

