/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.rmi.dgc.VMID;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.logging.Logger;

public class Ejb3Registry {
    private static final Logger log = Logger.getLogger(Ejb3Registry.class);
    private static Map<String, Container> containers = new HashMap<String, Container>();
    private static Map<String, Container> clusterContainers = new HashMap<String, Container>();
    private static final VMID vmid = new VMID();

    public static Container findContainer(String oid) {
        return containers.get(oid);
    }

    public static VMID getVMID() {
        return vmid;
    }

    public static boolean hasContainer(Container container) {
        return Ejb3Registry.hasContainer(Ejb3Registry.oid(container));
    }

    private static boolean hasContainer(String oid) {
        return containers.containsKey(oid);
    }

    private static final String oid(Container container) {
        return container.getObjectName().getCanonicalName();
    }

    public static boolean hasClusterContainer(String oid) {
        return clusterContainers.containsKey(oid);
    }

    public static final String guid(Container container, VMID vmid) {
        return container.getObjectName().getCanonicalName() + ",VMID=" + vmid;
    }

    public static final String guid(Container container) {
        return Ejb3Registry.guid(container, vmid);
    }

    public static final String clusterUid(Container container) {
        if (container.isClustered()) {
            return container.getObjectName().getCanonicalName() + ",Partition=" + ((EJBContainer)container).getPartitionName();
        }
        return container.getObjectName().getCanonicalName();
    }

    public static final String clusterUid(String oid, String partitionName) {
        return oid + ",Partition=" + partitionName;
    }

    public static void register(Container container) {
        String guid = Ejb3Registry.guid(container);
        if (Ejb3Registry.hasContainer(guid)) {
            throw new IllegalStateException("Container " + guid + " + is already registered");
        }
        containers.put(guid, container);
        if (container.isClustered()) {
            clusterContainers.put(Ejb3Registry.clusterUid(container), container);
        }
        log.debug((Object)("Registered container " + guid));
    }

    public static void unregister(Container container) {
        String guid = Ejb3Registry.guid(container);
        if (!Ejb3Registry.hasContainer(guid)) {
            throw new IllegalStateException("Container " + guid + " + is not registered");
        }
        containers.remove(guid);
        if (container.isClustered()) {
            clusterContainers.remove(Ejb3Registry.clusterUid(container));
        }
        log.debug((Object)("Unregistered container " + guid));
    }

    public static Container getContainer(String guid) {
        if (!Ejb3Registry.hasContainer(guid)) {
            throw new IllegalStateException("Container " + guid + " is not registered");
        }
        return containers.get(guid);
    }

    public static Container getClusterContainer(String clusterUid) {
        Container container = clusterContainers.get(clusterUid);
        if (container == null) {
            throw new IllegalStateException("Container " + clusterUid + " is not registered " + clusterContainers);
        }
        return container;
    }

    public static <T extends Container> T getContainer(String oid, Class<T> type) {
        return (T)Ejb3Registry.getContainer(oid);
    }

    public static Collection<Container> getContainers() {
        return Collections.unmodifiableCollection(containers.values());
    }
}

