/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public abstract class AbstractURLHandler
extends AbstractVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private final URL url;

    public AbstractURLHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) {
        super(context, parent, name);
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.url = url;
        this.initCacheLastModified();
    }

    protected URLConnection openConnection() throws IOException {
        return AbstractURLHandler.openConnection(this.url);
    }

    protected static URLConnection openConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCacheLastModified() {
        try {
            URLConnection c = this.openConnection();
            try {
                this.cachedLastModified = c.getLastModified();
            }
            finally {
                this.closeConnection(c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeConnection(URLConnection c) {
        block3: {
            try {
                if (!(c instanceof JarURLConnection)) {
                    c.getInputStream().close();
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"IGNORING: Exception while closing connection", (Throwable)ex);
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public URL toURL() throws MalformedURLException, URISyntaxException {
        return this.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() throws IOException {
        this.checkClosed();
        URLConnection c = this.openConnection();
        try {
            long l = c.getLastModified();
            return l;
        }
        finally {
            this.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws IOException {
        this.checkClosed();
        URLConnection c = this.openConnection();
        try {
            long l = c.getContentLength();
            return l;
        }
        finally {
            this.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws IOException {
        URLConnection c = this.openConnection();
        try {
            boolean bl = c.getLastModified() != 0L;
            return bl;
        }
        finally {
            this.closeConnection(c);
        }
    }

    public boolean isHidden() throws IOException {
        this.checkClosed();
        return false;
    }

    public InputStream openStream() throws IOException {
        this.checkClosed();
        URLConnection conn = this.openConnection();
        return conn.getInputStream();
    }

    public URI toURI() throws URISyntaxException {
        return VFSUtils.toURI(this.url);
    }
}

