/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.logging.impl.JULLogDelegateFactory;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.settings.impl.AddressSettings;

public class ConfigurationImpl
implements Configuration {
    private static final long serialVersionUID = 4077088945050267843L;
    public static final boolean DEFAULT_CLUSTERED = false;
    public static final boolean DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = false;
    public static final boolean DEFAULT_BACKUP = false;
    public static final boolean DEFAULT_ALLOW_AUTO_FAILBACK = true;
    public static final boolean DEFAULT_SHARED_STORE = true;
    public static final boolean DEFAULT_FILE_DEPLOYMENT_ENABLED = false;
    public static final boolean DEFAULT_PERSISTENCE_ENABLED = true;
    public static final long DEFAULT_FILE_DEPLOYER_SCAN_PERIOD = 5000L;
    public static final int DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE = 5;
    public static final int DEFAULT_THREAD_POOL_MAX_SIZE = 30;
    public static final long DEFAULT_SECURITY_INVALIDATION_INTERVAL = 10000L;
    public static final boolean DEFAULT_SECURITY_ENABLED = true;
    public static final boolean DEFAULT_JMX_MANAGEMENT_ENABLED = true;
    public static final String DEFAULT_JMX_DOMAIN = "org.hornetq";
    public static final long DEFAULT_CONNECTION_TTL_OVERRIDE = -1L;
    public static final boolean DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED = true;
    public static final String DEFAULT_BINDINGS_DIRECTORY = "data/bindings";
    public static final boolean DEFAULT_CREATE_BINDINGS_DIR = true;
    public static final String DEFAULT_JOURNAL_DIR = "data/journal";
    public static final String DEFAULT_PAGING_DIR = "data/paging";
    public static final String DEFAULT_LARGE_MESSAGES_DIR = "data/largemessages";
    public static final boolean DEFAULT_CREATE_JOURNAL_DIR = true;
    public static final JournalType DEFAULT_JOURNAL_TYPE = JournalType.ASYNCIO;
    public static final boolean DEFAULT_JOURNAL_SYNC_TRANSACTIONAL = true;
    public static final boolean DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL = true;
    public static final int DEFAULT_JOURNAL_FILE_SIZE = 0xA00000;
    public static final int DEFAULT_JOURNAL_COMPACT_MIN_FILES = 10;
    public static final int DEFAULT_JOURNAL_COMPACT_PERCENTAGE = 30;
    public static final int DEFAULT_JOURNAL_MIN_FILES = 2;
    public static final int DEFAULT_JOURNAL_MAX_IO_AIO = 500;
    public static final int DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO = 500000;
    public static final int DEFAULT_JOURNAL_BUFFER_SIZE_AIO = 501760;
    public static final int DEFAULT_JOURNAL_MAX_IO_NIO = 1;
    public static final int DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO = 3333333;
    public static final int DEFAULT_JOURNAL_BUFFER_SIZE_NIO = 501760;
    public static final boolean DEFAULT_JOURNAL_LOG_WRITE_RATE = false;
    public static final int DEFAULT_JOURNAL_PERF_BLAST_PAGES = -1;
    public static final boolean DEFAULT_RUN_SYNC_SPEED_TEST = false;
    public static final boolean DEFAULT_WILDCARD_ROUTING_ENABLED = true;
    public static final boolean DEFAULT_MESSAGE_COUNTER_ENABLED = false;
    public static final long DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD = 10000L;
    public static final int DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY = 10;
    public static final long DEFAULT_TRANSACTION_TIMEOUT = 300000L;
    public static final long DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD = 1000L;
    public static final SimpleString DEFAULT_MANAGEMENT_ADDRESS = new SimpleString("jms.queue.hornetq.management");
    public static final SimpleString DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS = new SimpleString("hornetq.notifications");
    public static final String DEFAULT_CLUSTER_USER = "HORNETQ.CLUSTER.ADMIN.USER";
    public static final String DEFAULT_CLUSTER_PASSWORD = "CHANGE ME!!";
    public static final long DEFAULT_BROADCAST_PERIOD = 2000L;
    public static final long DEFAULT_BROADCAST_REFRESH_TIMEOUT = 10000L;
    public static final long DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD = 30000L;
    public static final int DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY = 3;
    public static final int DEFAULT_ID_CACHE_SIZE = 2000;
    public static final boolean DEFAULT_PERSIST_ID_CACHE = true;
    public static final boolean DEFAULT_CLUSTER_DUPLICATE_DETECTION = true;
    public static final boolean DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS = false;
    public static final int DEFAULT_CLUSTER_MAX_HOPS = 1;
    public static final long DEFAULT_CLUSTER_RETRY_INTERVAL = 500L;
    public static final int DEFAULT_CLUSTER_RECONNECT_ATTEMPTS = -1;
    public static final long DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD = 30000L;
    public static final long DEFAULT_CLUSTER_CONNECTION_TTL = 60000L;
    public static final double DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER = 1.0;
    public static final long DEFAULT_CLUSTER_MAX_RETRY_INTERVAL = 2000L;
    public static final boolean DEFAULT_DIVERT_EXCLUSIVE = false;
    public static final boolean DEFAULT_BRIDGE_DUPLICATE_DETECTION = true;
    public static final int DEFAULT_BRIDGE_RECONNECT_ATTEMPTS = -1;
    public static final long DEFAULT_SERVER_DUMP_INTERVAL = -1L;
    private static final boolean DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN = false;
    public static final int DEFAULT_MEMORY_WARNING_THRESHOLD = 25;
    public static final long DEFAULT_MEMORY_MEASURE_INTERVAL = -1L;
    public static final long DEFAULT_FAILBACK_DELAY = 5000L;
    public static final String DEFAULT_LOG_DELEGATE_FACTORY_CLASS_NAME = JULLogDelegateFactory.class.getCanonicalName();
    protected String name = "ConfigurationImpl::" + System.identityHashCode(this);
    protected boolean clustered = false;
    protected boolean backup = false;
    protected boolean allowAutoFailBack = true;
    protected boolean sharedStore = true;
    protected boolean fileDeploymentEnabled = false;
    protected boolean persistenceEnabled = true;
    protected long fileDeploymentScanPeriod = 5000L;
    protected boolean persistDeliveryCountBeforeDelivery = false;
    protected int scheduledThreadPoolMaxSize = 5;
    protected int threadPoolMaxSize = 30;
    protected long securityInvalidationInterval = 10000L;
    protected boolean securityEnabled = true;
    protected boolean jmxManagementEnabled = true;
    protected String jmxDomain = "org.hornetq";
    protected long connectionTTLOverride = -1L;
    protected boolean asyncConnectionExecutionEnabled = true;
    protected long messageExpiryScanPeriod = 30000L;
    protected int messageExpiryThreadPriority = 3;
    protected int idCacheSize = 2000;
    protected boolean persistIDCache = true;
    protected String logDelegateFactoryClassName = DEFAULT_LOG_DELEGATE_FACTORY_CLASS_NAME;
    protected List<String> interceptorClassNames = new ArrayList<String>();
    protected Map<String, TransportConfiguration> connectorConfigs = new HashMap<String, TransportConfiguration>();
    protected Set<TransportConfiguration> acceptorConfigs = new HashSet<TransportConfiguration>();
    protected String liveConnectorName;
    protected List<BridgeConfiguration> bridgeConfigurations = new ArrayList<BridgeConfiguration>();
    protected List<DivertConfiguration> divertConfigurations = new ArrayList<DivertConfiguration>();
    protected List<ClusterConnectionConfiguration> clusterConfigurations = new ArrayList<ClusterConnectionConfiguration>();
    protected List<CoreQueueConfiguration> queueConfigurations = new ArrayList<CoreQueueConfiguration>();
    protected List<BroadcastGroupConfiguration> broadcastGroupConfigurations = new ArrayList<BroadcastGroupConfiguration>();
    protected Map<String, DiscoveryGroupConfiguration> discoveryGroupConfigurations = new LinkedHashMap<String, DiscoveryGroupConfiguration>();
    protected String pagingDirectory = "data/paging";
    protected String largeMessagesDirectory = "data/largemessages";
    protected String bindingsDirectory = "data/bindings";
    protected boolean createBindingsDir = true;
    protected String journalDirectory = "data/journal";
    protected boolean createJournalDir = true;
    public JournalType journalType = DEFAULT_JOURNAL_TYPE;
    protected boolean journalSyncTransactional = true;
    protected boolean journalSyncNonTransactional = true;
    protected int journalCompactMinFiles = 10;
    protected int journalCompactPercentage = 30;
    protected int journalFileSize = 0xA00000;
    protected int journalMinFiles = 2;
    protected int journalMaxIO_AIO = 500;
    protected int journalBufferTimeout_AIO = 500000;
    protected int journalBufferSize_AIO = 501760;
    protected int journalMaxIO_NIO = 1;
    protected int journalBufferTimeout_NIO = 3333333;
    protected int journalBufferSize_NIO = 501760;
    protected boolean logJournalWriteRate = false;
    protected int journalPerfBlastPages = -1;
    protected boolean runSyncSpeedTest = false;
    protected boolean wildcardRoutingEnabled = true;
    protected boolean messageCounterEnabled = false;
    protected long messageCounterSamplePeriod = 10000L;
    protected int messageCounterMaxDayHistory = 10;
    protected long transactionTimeout = 300000L;
    protected long transactionTimeoutScanPeriod = 1000L;
    protected SimpleString managementAddress = DEFAULT_MANAGEMENT_ADDRESS;
    protected SimpleString managementNotificationAddress = DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS;
    protected String clusterUser = "HORNETQ.CLUSTER.ADMIN.USER";
    protected String clusterPassword = "CHANGE ME!!";
    protected long serverDumpInterval = -1L;
    protected boolean failoverOnServerShutdown = false;
    protected int memoryWarningThreshold = 25;
    protected long memoryMeasureInterval = -1L;
    protected GroupingHandlerConfiguration groupingHandlerConfiguration;
    private Map<String, AddressSettings> addressesSettings = new HashMap<String, AddressSettings>();
    private Map<String, Set<Role>> securitySettings = new HashMap<String, Set<Role>>();
    protected List<ConnectorServiceConfiguration> connectorServiceConfigurations = new ArrayList<ConnectorServiceConfiguration>();
    private long failbackDelay = 5000L;

    @Override
    public boolean isClustered() {
        return this.clustered;
    }

    @Override
    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    @Override
    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    @Override
    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    @Override
    public boolean isBackup() {
        return this.backup;
    }

    @Override
    public boolean isFileDeploymentEnabled() {
        return this.fileDeploymentEnabled;
    }

    @Override
    public void setFileDeploymentEnabled(boolean enable) {
        this.fileDeploymentEnabled = enable;
    }

    @Override
    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @Override
    public void setPersistenceEnabled(boolean enable) {
        this.persistenceEnabled = enable;
    }

    @Override
    public long getFileDeployerScanPeriod() {
        return this.fileDeploymentScanPeriod;
    }

    @Override
    public void setFileDeployerScanPeriod(long period) {
        this.fileDeploymentScanPeriod = period;
    }

    @Override
    public boolean isPersistDeliveryCountBeforeDelivery() {
        return this.persistDeliveryCountBeforeDelivery;
    }

    @Override
    public void setPersistDeliveryCountBeforeDelivery(boolean persistDeliveryCountBeforeDelivery) {
        this.persistDeliveryCountBeforeDelivery = persistDeliveryCountBeforeDelivery;
    }

    @Override
    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    @Override
    public boolean isSharedStore() {
        return this.sharedStore;
    }

    @Override
    public void setSharedStore(boolean sharedStore) {
        this.sharedStore = sharedStore;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public void setScheduledThreadPoolMaxSize(int maxSize) {
        this.scheduledThreadPoolMaxSize = maxSize;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public void setThreadPoolMaxSize(int maxSize) {
        this.threadPoolMaxSize = maxSize;
    }

    @Override
    public long getSecurityInvalidationInterval() {
        return this.securityInvalidationInterval;
    }

    @Override
    public void setSecurityInvalidationInterval(long interval) {
        this.securityInvalidationInterval = interval;
    }

    @Override
    public long getConnectionTTLOverride() {
        return this.connectionTTLOverride;
    }

    @Override
    public void setConnectionTTLOverride(long ttl) {
        this.connectionTTLOverride = ttl;
    }

    @Override
    public boolean isAsyncConnectionExecutionEnabled() {
        return this.asyncConnectionExecutionEnabled;
    }

    @Override
    public void setEnabledAsyncConnectionExecution(boolean enabled) {
        this.asyncConnectionExecutionEnabled = enabled;
    }

    @Override
    public List<String> getInterceptorClassNames() {
        return this.interceptorClassNames;
    }

    @Override
    public void setInterceptorClassNames(List<String> interceptors) {
        this.interceptorClassNames = interceptors;
    }

    @Override
    public Set<TransportConfiguration> getAcceptorConfigurations() {
        return this.acceptorConfigs;
    }

    @Override
    public void setAcceptorConfigurations(Set<TransportConfiguration> infos) {
        this.acceptorConfigs = infos;
    }

    @Override
    public Map<String, TransportConfiguration> getConnectorConfigurations() {
        return this.connectorConfigs;
    }

    @Override
    public void setConnectorConfigurations(Map<String, TransportConfiguration> infos) {
        this.connectorConfigs = infos;
    }

    @Override
    public String getLiveConnectorName() {
        return this.liveConnectorName;
    }

    @Override
    public void setLiveConnectorName(String liveConnectorName) {
        this.liveConnectorName = liveConnectorName;
    }

    @Override
    public GroupingHandlerConfiguration getGroupingHandlerConfiguration() {
        return this.groupingHandlerConfiguration;
    }

    @Override
    public void setGroupingHandlerConfiguration(GroupingHandlerConfiguration groupingHandlerConfiguration) {
        this.groupingHandlerConfiguration = groupingHandlerConfiguration;
    }

    @Override
    public List<BridgeConfiguration> getBridgeConfigurations() {
        return this.bridgeConfigurations;
    }

    @Override
    public void setBridgeConfigurations(List<BridgeConfiguration> configs) {
        this.bridgeConfigurations = configs;
    }

    @Override
    public List<BroadcastGroupConfiguration> getBroadcastGroupConfigurations() {
        return this.broadcastGroupConfigurations;
    }

    @Override
    public void setBroadcastGroupConfigurations(List<BroadcastGroupConfiguration> configs) {
        this.broadcastGroupConfigurations = configs;
    }

    @Override
    public List<ClusterConnectionConfiguration> getClusterConfigurations() {
        return this.clusterConfigurations;
    }

    @Override
    public void setClusterConfigurations(List<ClusterConnectionConfiguration> configs) {
        this.clusterConfigurations = configs;
    }

    @Override
    public List<DivertConfiguration> getDivertConfigurations() {
        return this.divertConfigurations;
    }

    @Override
    public void setDivertConfigurations(List<DivertConfiguration> configs) {
        this.divertConfigurations = configs;
    }

    @Override
    public List<CoreQueueConfiguration> getQueueConfigurations() {
        return this.queueConfigurations;
    }

    @Override
    public void setQueueConfigurations(List<CoreQueueConfiguration> configs) {
        this.queueConfigurations = configs;
    }

    @Override
    public Map<String, DiscoveryGroupConfiguration> getDiscoveryGroupConfigurations() {
        return this.discoveryGroupConfigurations;
    }

    @Override
    public void setDiscoveryGroupConfigurations(Map<String, DiscoveryGroupConfiguration> discoveryGroupConfigurations) {
        this.discoveryGroupConfigurations = discoveryGroupConfigurations;
    }

    @Override
    public int getIDCacheSize() {
        return this.idCacheSize;
    }

    @Override
    public void setIDCacheSize(int idCacheSize) {
        this.idCacheSize = idCacheSize;
    }

    @Override
    public boolean isPersistIDCache() {
        return this.persistIDCache;
    }

    @Override
    public void setPersistIDCache(boolean persist) {
        this.persistIDCache = persist;
    }

    @Override
    public String getBindingsDirectory() {
        return this.bindingsDirectory;
    }

    @Override
    public void setBindingsDirectory(String dir) {
        this.bindingsDirectory = dir;
    }

    @Override
    public String getJournalDirectory() {
        return this.journalDirectory;
    }

    @Override
    public void setJournalDirectory(String dir) {
        this.journalDirectory = dir;
    }

    @Override
    public JournalType getJournalType() {
        return this.journalType;
    }

    @Override
    public void setPagingDirectory(String dir) {
        this.pagingDirectory = dir;
    }

    @Override
    public String getPagingDirectory() {
        return this.pagingDirectory;
    }

    @Override
    public void setJournalType(JournalType type) {
        this.journalType = type;
    }

    @Override
    public boolean isJournalSyncTransactional() {
        return this.journalSyncTransactional;
    }

    @Override
    public void setJournalSyncTransactional(boolean sync) {
        this.journalSyncTransactional = sync;
    }

    @Override
    public boolean isJournalSyncNonTransactional() {
        return this.journalSyncNonTransactional;
    }

    @Override
    public void setJournalSyncNonTransactional(boolean sync) {
        this.journalSyncNonTransactional = sync;
    }

    @Override
    public int getJournalFileSize() {
        return this.journalFileSize;
    }

    @Override
    public void setJournalFileSize(int size) {
        this.journalFileSize = size;
    }

    @Override
    public int getJournalMinFiles() {
        return this.journalMinFiles;
    }

    @Override
    public void setJournalMinFiles(int files) {
        this.journalMinFiles = files;
    }

    @Override
    public boolean isLogJournalWriteRate() {
        return this.logJournalWriteRate;
    }

    @Override
    public void setLogJournalWriteRate(boolean logJournalWriteRate) {
        this.logJournalWriteRate = logJournalWriteRate;
    }

    @Override
    public int getJournalPerfBlastPages() {
        return this.journalPerfBlastPages;
    }

    @Override
    public void setJournalPerfBlastPages(int journalPerfBlastPages) {
        this.journalPerfBlastPages = journalPerfBlastPages;
    }

    @Override
    public boolean isRunSyncSpeedTest() {
        return this.runSyncSpeedTest;
    }

    @Override
    public void setRunSyncSpeedTest(boolean run) {
        this.runSyncSpeedTest = run;
    }

    @Override
    public boolean isCreateBindingsDir() {
        return this.createBindingsDir;
    }

    @Override
    public void setCreateBindingsDir(boolean create) {
        this.createBindingsDir = create;
    }

    @Override
    public boolean isCreateJournalDir() {
        return this.createJournalDir;
    }

    @Override
    public void setCreateJournalDir(boolean create) {
        this.createJournalDir = create;
    }

    @Override
    public boolean isWildcardRoutingEnabled() {
        return this.wildcardRoutingEnabled;
    }

    @Override
    public void setWildcardRoutingEnabled(boolean enabled) {
        this.wildcardRoutingEnabled = enabled;
    }

    @Override
    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public void setTransactionTimeout(long timeout) {
        this.transactionTimeout = timeout;
    }

    @Override
    public long getTransactionTimeoutScanPeriod() {
        return this.transactionTimeoutScanPeriod;
    }

    @Override
    public void setTransactionTimeoutScanPeriod(long period) {
        this.transactionTimeoutScanPeriod = period;
    }

    @Override
    public long getMessageExpiryScanPeriod() {
        return this.messageExpiryScanPeriod;
    }

    @Override
    public void setMessageExpiryScanPeriod(long messageExpiryScanPeriod) {
        this.messageExpiryScanPeriod = messageExpiryScanPeriod;
    }

    @Override
    public int getMessageExpiryThreadPriority() {
        return this.messageExpiryThreadPriority;
    }

    @Override
    public void setMessageExpiryThreadPriority(int messageExpiryThreadPriority) {
        this.messageExpiryThreadPriority = messageExpiryThreadPriority;
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public void setSecurityEnabled(boolean enabled) {
        this.securityEnabled = enabled;
    }

    @Override
    public boolean isJMXManagementEnabled() {
        return this.jmxManagementEnabled;
    }

    @Override
    public void setJMXManagementEnabled(boolean enabled) {
        this.jmxManagementEnabled = enabled;
    }

    @Override
    public String getJMXDomain() {
        return this.jmxDomain;
    }

    @Override
    public void setJMXDomain(String domain) {
        this.jmxDomain = domain;
    }

    @Override
    public String getLargeMessagesDirectory() {
        return this.largeMessagesDirectory;
    }

    @Override
    public void setLargeMessagesDirectory(String directory) {
        this.largeMessagesDirectory = directory;
    }

    @Override
    public boolean isMessageCounterEnabled() {
        return this.messageCounterEnabled;
    }

    @Override
    public void setMessageCounterEnabled(boolean enabled) {
        this.messageCounterEnabled = enabled;
    }

    @Override
    public long getMessageCounterSamplePeriod() {
        return this.messageCounterSamplePeriod;
    }

    @Override
    public void setMessageCounterSamplePeriod(long period) {
        this.messageCounterSamplePeriod = period;
    }

    @Override
    public int getMessageCounterMaxDayHistory() {
        return this.messageCounterMaxDayHistory;
    }

    @Override
    public void setMessageCounterMaxDayHistory(int maxDayHistory) {
        this.messageCounterMaxDayHistory = maxDayHistory;
    }

    @Override
    public SimpleString getManagementAddress() {
        return this.managementAddress;
    }

    @Override
    public void setManagementAddress(SimpleString address) {
        this.managementAddress = address;
    }

    @Override
    public SimpleString getManagementNotificationAddress() {
        return this.managementNotificationAddress;
    }

    @Override
    public void setManagementNotificationAddress(SimpleString address) {
        this.managementNotificationAddress = address;
    }

    @Override
    public String getClusterUser() {
        return this.clusterUser;
    }

    @Override
    public void setClusterUser(String user) {
        this.clusterUser = user;
    }

    @Override
    public String getClusterPassword() {
        return this.clusterPassword;
    }

    @Override
    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    @Override
    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    @Override
    public void setClusterPassword(String theclusterPassword) {
        this.clusterPassword = theclusterPassword;
    }

    @Override
    public int getJournalCompactMinFiles() {
        return this.journalCompactMinFiles;
    }

    @Override
    public int getJournalCompactPercentage() {
        return this.journalCompactPercentage;
    }

    @Override
    public void setJournalCompactMinFiles(int minFiles) {
        this.journalCompactMinFiles = minFiles;
    }

    @Override
    public void setJournalCompactPercentage(int percentage) {
        this.journalCompactPercentage = percentage;
    }

    @Override
    public long getServerDumpInterval() {
        return this.serverDumpInterval;
    }

    @Override
    public void setServerDumpInterval(long intervalInMilliseconds) {
        this.serverDumpInterval = intervalInMilliseconds;
    }

    @Override
    public int getMemoryWarningThreshold() {
        return this.memoryWarningThreshold;
    }

    @Override
    public void setMemoryWarningThreshold(int memoryWarningThreshold) {
        this.memoryWarningThreshold = memoryWarningThreshold;
    }

    @Override
    public long getMemoryMeasureInterval() {
        return this.memoryMeasureInterval;
    }

    @Override
    public void setMemoryMeasureInterval(long memoryMeasureInterval) {
        this.memoryMeasureInterval = memoryMeasureInterval;
    }

    @Override
    public String getLogDelegateFactoryClassName() {
        return this.logDelegateFactoryClassName;
    }

    @Override
    public void setLogDelegateFactoryClassName(String className) {
        this.logDelegateFactoryClassName = className;
    }

    @Override
    public int getJournalMaxIO_AIO() {
        return this.journalMaxIO_AIO;
    }

    @Override
    public void setJournalMaxIO_AIO(int journalMaxIO) {
        this.journalMaxIO_AIO = journalMaxIO;
    }

    @Override
    public int getJournalBufferTimeout_AIO() {
        return this.journalBufferTimeout_AIO;
    }

    @Override
    public void setJournalBufferTimeout_AIO(int journalBufferTimeout) {
        this.journalBufferTimeout_AIO = journalBufferTimeout;
    }

    @Override
    public int getJournalBufferSize_AIO() {
        return this.journalBufferSize_AIO;
    }

    @Override
    public void setJournalBufferSize_AIO(int journalBufferSize) {
        this.journalBufferSize_AIO = journalBufferSize;
    }

    @Override
    public int getJournalMaxIO_NIO() {
        return this.journalMaxIO_NIO;
    }

    @Override
    public void setJournalMaxIO_NIO(int journalMaxIO) {
        this.journalMaxIO_NIO = journalMaxIO;
    }

    @Override
    public int getJournalBufferTimeout_NIO() {
        return this.journalBufferTimeout_NIO;
    }

    @Override
    public void setJournalBufferTimeout_NIO(int journalBufferTimeout) {
        this.journalBufferTimeout_NIO = journalBufferTimeout;
    }

    @Override
    public int getJournalBufferSize_NIO() {
        return this.journalBufferSize_NIO;
    }

    @Override
    public void setJournalBufferSize_NIO(int journalBufferSize) {
        this.journalBufferSize_NIO = journalBufferSize;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationImpl other = (ConfigurationImpl)obj;
        if (this.asyncConnectionExecutionEnabled != other.asyncConnectionExecutionEnabled) {
            return false;
        }
        if (this.backup != other.backup) {
            return false;
        }
        if (this.sharedStore != other.sharedStore) {
            return false;
        }
        if (this.liveConnectorName == null ? other.liveConnectorName != null : !this.liveConnectorName.equals(other.liveConnectorName)) {
            return false;
        }
        if (this.bindingsDirectory == null ? other.bindingsDirectory != null : !this.bindingsDirectory.equals(other.bindingsDirectory)) {
            return false;
        }
        if (this.clustered != other.clustered) {
            return false;
        }
        if (this.connectionTTLOverride != other.connectionTTLOverride) {
            return false;
        }
        if (this.createBindingsDir != other.createBindingsDir) {
            return false;
        }
        if (this.createJournalDir != other.createJournalDir) {
            return false;
        }
        if (this.fileDeploymentEnabled != other.fileDeploymentEnabled) {
            return false;
        }
        if (this.fileDeploymentScanPeriod != other.fileDeploymentScanPeriod) {
            return false;
        }
        if (this.idCacheSize != other.idCacheSize) {
            return false;
        }
        if (this.jmxManagementEnabled != other.jmxManagementEnabled) {
            return false;
        }
        if (this.journalBufferSize_AIO != other.journalBufferSize_AIO) {
            return false;
        }
        if (this.journalBufferTimeout_AIO != other.journalBufferTimeout_AIO) {
            return false;
        }
        if (this.journalMaxIO_AIO != other.journalMaxIO_AIO) {
            return false;
        }
        if (this.journalBufferSize_NIO != other.journalBufferSize_NIO) {
            return false;
        }
        if (this.journalBufferTimeout_NIO != other.journalBufferTimeout_NIO) {
            return false;
        }
        if (this.journalMaxIO_NIO != other.journalMaxIO_NIO) {
            return false;
        }
        if (this.journalCompactMinFiles != other.journalCompactMinFiles) {
            return false;
        }
        if (this.journalCompactPercentage != other.journalCompactPercentage) {
            return false;
        }
        if (this.journalDirectory == null ? other.journalDirectory != null : !this.journalDirectory.equals(other.journalDirectory)) {
            return false;
        }
        if (this.journalFileSize != other.journalFileSize) {
            return false;
        }
        if (this.journalMinFiles != other.journalMinFiles) {
            return false;
        }
        if (this.journalPerfBlastPages != other.journalPerfBlastPages) {
            return false;
        }
        if (this.journalSyncNonTransactional != other.journalSyncNonTransactional) {
            return false;
        }
        if (this.journalSyncTransactional != other.journalSyncTransactional) {
            return false;
        }
        if (this.journalType == null ? other.journalType != null : !this.journalType.equals((Object)other.journalType)) {
            return false;
        }
        if (this.largeMessagesDirectory == null ? other.largeMessagesDirectory != null : !this.largeMessagesDirectory.equals(other.largeMessagesDirectory)) {
            return false;
        }
        if (this.logJournalWriteRate != other.logJournalWriteRate) {
            return false;
        }
        if (this.managementAddress == null ? other.managementAddress != null : !this.managementAddress.equals(other.managementAddress)) {
            return false;
        }
        if (this.failoverOnServerShutdown != other.isFailoverOnServerShutdown()) {
            return false;
        }
        if (this.clusterPassword == null ? other.clusterPassword != null : !this.clusterPassword.equals(other.clusterPassword)) {
            return false;
        }
        if (this.clusterUser == null ? other.clusterUser != null : !this.clusterUser.equals(other.clusterUser)) {
            return false;
        }
        if (this.managementNotificationAddress == null ? other.managementNotificationAddress != null : !this.managementNotificationAddress.equals(other.managementNotificationAddress)) {
            return false;
        }
        if (this.messageCounterEnabled != other.messageCounterEnabled) {
            return false;
        }
        if (this.messageCounterMaxDayHistory != other.messageCounterMaxDayHistory) {
            return false;
        }
        if (this.messageCounterSamplePeriod != other.messageCounterSamplePeriod) {
            return false;
        }
        if (this.messageExpiryScanPeriod != other.messageExpiryScanPeriod) {
            return false;
        }
        if (this.messageExpiryThreadPriority != other.messageExpiryThreadPriority) {
            return false;
        }
        if (this.pagingDirectory == null ? other.pagingDirectory != null : !this.pagingDirectory.equals(other.pagingDirectory)) {
            return false;
        }
        if (this.persistDeliveryCountBeforeDelivery != other.persistDeliveryCountBeforeDelivery) {
            return false;
        }
        if (this.persistIDCache != other.persistIDCache) {
            return false;
        }
        if (this.persistenceEnabled != other.persistenceEnabled) {
            return false;
        }
        if (this.scheduledThreadPoolMaxSize != other.scheduledThreadPoolMaxSize) {
            return false;
        }
        if (this.securityEnabled != other.securityEnabled) {
            return false;
        }
        if (this.securityInvalidationInterval != other.securityInvalidationInterval) {
            return false;
        }
        if (this.serverDumpInterval != other.serverDumpInterval) {
            return false;
        }
        if (this.threadPoolMaxSize != other.threadPoolMaxSize) {
            return false;
        }
        if (this.transactionTimeout != other.transactionTimeout) {
            return false;
        }
        if (this.transactionTimeoutScanPeriod != other.transactionTimeoutScanPeriod) {
            return false;
        }
        return this.wildcardRoutingEnabled == other.wildcardRoutingEnabled;
    }

    @Override
    public Map<String, AddressSettings> getAddressesSettings() {
        return this.addressesSettings;
    }

    @Override
    public void setAddressesSettings(Map<String, AddressSettings> addressesSettings) {
        this.addressesSettings = addressesSettings;
    }

    @Override
    public Map<String, Set<Role>> getSecurityRoles() {
        return this.securitySettings;
    }

    @Override
    public void setSecurityRoles(Map<String, Set<Role>> securitySettings) {
        this.securitySettings = securitySettings;
    }

    @Override
    public List<ConnectorServiceConfiguration> getConnectorServiceConfigurations() {
        return this.connectorServiceConfigurations;
    }

    @Override
    public long getFailbackDelay() {
        return this.failbackDelay;
    }

    @Override
    public void setFailbackDelay(long failbackDelay) {
        this.failbackDelay = failbackDelay;
    }

    @Override
    public void setConnectorServiceConfigurations(List<ConnectorServiceConfiguration> configs) {
        this.connectorServiceConfigurations = configs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("HornetQ Configuration (");
        sb.append("clustered=").append(this.clustered).append(",");
        sb.append("backup=").append(this.backup).append(",");
        sb.append("sharedStore=").append(this.sharedStore).append(",");
        sb.append("journalDirectory=").append(this.journalDirectory).append(",");
        sb.append("bindingsDirectory=").append(this.bindingsDirectory).append(",");
        sb.append("largeMessagesDirectory=").append(this.largeMessagesDirectory).append(",");
        sb.append("pagingDirectory=").append(this.pagingDirectory);
        sb.append(")");
        return sb.toString();
    }
}

