/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.jboss.ejb3.annotation.JndiInject;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.injection.LinkRefEncInjector;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.javaee.jboss.JndiRefMetaData;
import org.jboss.metadata.javaee.jboss.JndiRefsMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;

public class JndiInjectHandler<X extends RemoteEnvironment>
implements InjectionHandler<X> {
    private static final Logger log = Logger.getLogger(JndiInjectHandler.class);

    @Override
    public void loadXml(X xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (!(xml instanceof JBossEnterpriseBeanMetaData)) {
            return;
        }
        JndiRefsMetaData jndiRefs = ((JBossEnterpriseBeanMetaData)xml).getJndiRefs();
        if (jndiRefs == null) {
            return;
        }
        for (JndiRefMetaData ref : jndiRefs) {
            if (ref.getMappedName() == null || ref.getMappedName().equals("")) {
                throw new RuntimeException("mapped-name is required for " + ref.getJndiRefName() + " of container " + container.getIdentifier());
            }
            String encName = "env/" + ref.getJndiRefName();
            if (!container.getEncInjectors().containsKey(encName)) {
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.getMappedName(), "jndi ref"));
            }
            InjectionUtil.injectionTarget(encName, (ResourceInjectionMetaData)ref, container, container.getEncInjections());
        }
    }

    @Override
    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        JndiInject ref = method.getAnnotation(JndiInject.class);
        if (ref != null) {
            if (!method.getName().startsWith("set")) {
                throw new RuntimeException("@EJB can only be used with a set method: " + method);
            }
            String encName = InjectionUtil.getEncName(method);
            if (!container.getEncInjectors().containsKey(encName)) {
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.jndiName(), "@JndiInject"));
            }
            injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
        }
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        JndiInject ref = field.getAnnotation(JndiInject.class);
        if (ref != null) {
            String encName = InjectionUtil.getEncName(field);
            if (!container.getEncInjectors().containsKey(encName)) {
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.jndiName(), "@JndiInject"));
            }
            injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
        }
    }
}

