/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientProducerCreditManager;
import org.hornetq.core.client.impl.ClientProducerCredits;
import org.hornetq.core.client.impl.ClientProducerCreditsImpl;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.logging.Logger;

public class ClientProducerCreditManagerImpl
implements ClientProducerCreditManager {
    private static final Logger log = Logger.getLogger(ClientProducerCreditManagerImpl.class);
    public static final int MAX_UNREFERENCED_CREDITS_CACHE_SIZE = 1000;
    private final Map<SimpleString, ClientProducerCredits> producerCredits = new LinkedHashMap<SimpleString, ClientProducerCredits>();
    private final Map<SimpleString, ClientProducerCredits> unReferencedCredits = new LinkedHashMap<SimpleString, ClientProducerCredits>();
    private final ClientSessionInternal session;
    private final int windowSize;

    public ClientProducerCreditManagerImpl(ClientSessionInternal session, int windowSize) {
        this.session = session;
        this.windowSize = windowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientProducerCredits getCredits(SimpleString address, boolean anon) {
        ClientProducerCredits credits;
        boolean needInit = false;
        ClientProducerCreditManagerImpl clientProducerCreditManagerImpl = this;
        synchronized (clientProducerCreditManagerImpl) {
            credits = this.producerCredits.get(address);
            if (credits == null) {
                credits = new ClientProducerCreditsImpl(this.session, address, this.windowSize);
                needInit = true;
                this.producerCredits.put(address, credits);
            }
            if (!anon) {
                credits.incrementRefCount();
                this.unReferencedCredits.remove(address);
            } else {
                this.addToUnReferencedCache(address, credits);
            }
        }
        if (needInit) {
            credits.init();
        }
        return credits;
    }

    public synchronized void returnCredits(SimpleString address) {
        ClientProducerCredits credits = this.producerCredits.get(address);
        if (credits != null && credits.decrementRefCount() == 0) {
            this.addToUnReferencedCache(address, credits);
        }
    }

    public synchronized void receiveCredits(SimpleString address, int credits) {
        ClientProducerCredits cr = this.producerCredits.get(address);
        if (cr != null) {
            cr.receiveCredits(credits);
        }
    }

    public synchronized void reset() {
        for (ClientProducerCredits credits : this.producerCredits.values()) {
            credits.reset();
        }
    }

    public synchronized void close() {
        for (ClientProducerCredits credits : this.producerCredits.values()) {
            credits.close();
        }
        this.producerCredits.clear();
        this.unReferencedCredits.clear();
    }

    public synchronized int creditsMapSize() {
        return this.producerCredits.size();
    }

    public synchronized int unReferencedCreditsSize() {
        return this.unReferencedCredits.size();
    }

    private void addToUnReferencedCache(SimpleString address, ClientProducerCredits credits) {
        this.unReferencedCredits.put(address, credits);
        if (this.unReferencedCredits.size() > 1000) {
            Iterator<Map.Entry<SimpleString, ClientProducerCredits>> iter = this.unReferencedCredits.entrySet().iterator();
            Map.Entry<SimpleString, ClientProducerCredits> oldest = iter.next();
            iter.remove();
            this.removeEntry(oldest.getKey(), oldest.getValue());
        }
    }

    private void removeEntry(SimpleString address, ClientProducerCredits credits) {
        this.producerCredits.remove(address);
        credits.releaseOutstanding();
        credits.close();
    }
}

