/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;

public class BigDecimalType
extends ImmutableType {
    @Override
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        return rs.getBigDecimal(name);
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        st.setBigDecimal(index, (BigDecimal)value);
    }

    @Override
    public int sqlType() {
        return 2;
    }

    @Override
    public String toString(Object value) throws HibernateException {
        return value.toString();
    }

    @Override
    public Class getReturnedClass() {
        return BigDecimal.class;
    }

    @Override
    public boolean isEqual(Object x, Object y) {
        return x == y || x != null && y != null && ((BigDecimal)x).compareTo((BigDecimal)y) == 0;
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        return ((BigDecimal)x).intValue();
    }

    @Override
    public String getName() {
        return "big_decimal";
    }

    @Override
    public Object fromStringValue(String xml) {
        return new BigDecimal(xml);
    }
}

