/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpUInt32
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 6360915905545058942L;
    private long m_value;
    private static final long MASK = 0xFFFFFFFFL;
    public static final byte ASNTYPE = 66;

    public SnmpUInt32() {
        this.m_value = 0L;
    }

    public SnmpUInt32(long value) {
        this.m_value = value & 0xFFFFFFFFL;
    }

    public SnmpUInt32(Long value) {
        this((long)value);
    }

    public SnmpUInt32(SnmpUInt32 second) {
        this.m_value = second.m_value;
    }

    public SnmpUInt32(String value) {
        if (value == null) {
            throw new NullPointerException("The construction argument cannot be null");
        }
        this.m_value = Long.parseLong(value);
        if (this.m_value < 0L) {
            throw new IllegalArgumentException("Illegal Negative Integer Value");
        }
        this.m_value &= 0xFFFFFFFFL;
    }

    public long getValue() {
        return this.m_value & 0xFFFFFFFFL;
    }

    public void setValue(long value) {
        this.m_value = value & 0xFFFFFFFFL;
    }

    public void setValue(Long value) {
        this.m_value = value & 0xFFFFFFFFL;
    }

    @Override
    public byte typeId() {
        return 66;
    }

    @Override
    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        return encoder.buildUInteger32(buf, offset, this.typeId(), this.getValue());
    }

    @Override
    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseUInteger32(buf, offset);
        if (((Byte)rVals[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.setValue((Long)rVals[2]);
        return (Integer)rVals[0];
    }

    @Override
    public SnmpSyntax duplicate() {
        return new SnmpUInt32(this);
    }

    public Object clone() {
        return new SnmpUInt32(this);
    }

    public String toString() {
        return Long.toString(this.getValue());
    }
}

