/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.IllegalNonFormParametersRequest;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.PresetParameter;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebRequestSource;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

abstract class FixedURLWebRequestSource
extends WebRequestSource {
    private static final String[] NO_VALUES = new String[0];
    private Map _presetParameterMap;
    private ArrayList _presetParameterList;
    private String _characterSet;

    public FixedURLWebRequestSource(WebResponse response, Node node, URL baseURL, String destination, FrameSelector frame, String defaultTarget, String characterSet) {
        super(response, node, baseURL, destination, frame, defaultTarget);
        this._characterSet = characterSet;
    }

    @Override
    public WebRequest getRequest() {
        return new GetMethodWebRequest(this);
    }

    @Override
    public String[] getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.getPresetParameterMap().keySet());
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    @Override
    public String[] getParameterValues(String name) {
        String[] values = (String[])this.getPresetParameterMap().get(name);
        return values == null ? NO_VALUES : values;
    }

    @Override
    protected void addPresetParameter(String name, String value) {
        this._presetParameterMap.put(name, HttpUnitUtils.withNewValue((String[])this._presetParameterMap.get(name), value));
        this._presetParameterList.add(new PresetParameter(name, value));
    }

    @Override
    protected String getEmptyParameterValue() {
        return "";
    }

    @Override
    protected void setDestination(String destination) {
        super.setDestination(destination);
        this._presetParameterList = null;
        this._presetParameterMap = null;
    }

    @Override
    void selectImageButtonPosition(SubmitButton imageButton, int x, int y) {
        throw new IllegalNonFormParametersRequest();
    }

    @Override
    void recordPredefinedParameters(ParameterProcessor processor) throws IOException {
    }

    @Override
    void recordParameters(ParameterProcessor processor) throws IOException {
        for (PresetParameter o : this.getPresetParameterList()) {
            processor.addParameter(o.getName(), o.getValue(), this.getCharacterSet());
        }
    }

    @Override
    void removeParameter(String name) {
        throw new IllegalNonFormParametersRequest();
    }

    @Override
    void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    @Override
    void setParameter(String name, String[] values) {
        if (values == null) {
            throw new IllegalArgumentException("May not supply a null argument array to setParameter()");
        }
        if (!this.getPresetParameterMap().containsKey(name)) {
            throw new IllegalNonFormParametersRequest();
        }
        if (!this.equals(this.getParameterValues(name), values)) {
            throw new IllegalNonFormParametersRequest();
        }
    }

    @Override
    String getCharacterSet() {
        return this._characterSet;
    }

    private boolean equals(String[] left, String[] right) {
        if (left.length != right.length) {
            return false;
        }
        List<String> rightValues = Arrays.asList(right);
        for (int i = 0; i < left.length; ++i) {
            if (rightValues.contains(left[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    void setParameter(String name, UploadFileSpec[] files) {
        throw new IllegalNonFormParametersRequest();
    }

    @Override
    boolean isFileParameter(String name) {
        return false;
    }

    @Override
    boolean isSubmitAsMime() {
        return false;
    }

    @Override
    void setSubmitAsMime(boolean mimeEncoded) {
        throw new IllegalStateException("May not change the encoding for a validated request created from a link");
    }

    private Map getPresetParameterMap() {
        if (this._presetParameterMap == null) {
            this.loadPresetParameters();
        }
        return this._presetParameterMap;
    }

    private ArrayList getPresetParameterList() {
        if (this._presetParameterList == null) {
            this.loadPresetParameters();
        }
        return this._presetParameterList;
    }

    private void loadPresetParameters() {
        this._presetParameterMap = new HashMap();
        this._presetParameterList = new ArrayList();
        this.loadDestinationParameters();
    }
}

