package org.jboss.seam.test.integration;

import org.jboss.seam.Component;
import org.jboss.seam.mock.SeamTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PrecedenceComponentTest extends SeamTest
{
   
    /**
     * Test if precedence of component is working correctly
     * components.xml specifies component1 with 2 possible
     *  configuration - first has got higher precedence than
     *  second and the first should set component1.name property 
     *  to Componen1High. Result should be that even last component1
     *  is set the higher precedence configuration has to be set and 
     *  remain as the only one available.
     *  JBPAPP-8159 and JBSEAM-3138
     * @throws Exception
     */
    @Test
    public void testPrecedenceComponents() throws Exception
    {       
       
       new FacesRequest()
       {
          @Override
          protected void invokeApplication() throws Exception {
              Object component = Component.getInstance("component1");
              if (!(component instanceof Component2))              
              {
                 Assert.fail("component is not expected Component2.class");
              }
              Component2 myPrecedenceComponent = (Component2) component;
              Assert.assertEquals(myPrecedenceComponent.getName(), "Component1High");
              Assert.assertEquals(myPrecedenceComponent.getDefaultValue(), "Component2default");
          }   
       }.run();
    }
    
}
