/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metatype.plugins.values.mappers;

import java.lang.reflect.Type;
import java.util.Hashtable;

import javax.management.ObjectName;

import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.plugins.types.ObjectNameTypeBuilder;
import org.jboss.metatype.spi.values.MetaMapper;

/**
 * A MetaMapper for ObjectName to CompositeValue using domain, keyPropertyList
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class PropertiesCompositeObjectNameMetaMapper extends MetaMapper<ObjectName>
{

   @Override
   public MetaType getMetaType()
   {
      return ObjectNameTypeBuilder.META_TYPE;
   }
   @Override
   public Type mapToType()
   {
      return ObjectName.class;
   }

   @Override
   public MetaValue createMetaValue(MetaType metaType, ObjectName object)
   {
      String[] itemNames = {"domain", "keyPropertyList"};
      PropertiesMetaValue keyValues = new PropertiesMetaValue();
      for(Object key : object.getKeyPropertyList().keySet())
      {
         Object value = object.getKeyProperty((String)key);
         keyValues.put(key, value);
      }
      MetaValue[] itemValues = {SimpleValueSupport.wrap(object.getDomain()), keyValues};
      CompositeValueSupport mv = new CompositeValueSupport(ObjectNameTypeBuilder.META_TYPE,
            itemNames, itemValues);
      return mv;
   }

   @Override
   public ObjectName unwrapMetaValue(MetaValue metaValue)
   {
      CompositeValue compositeValue = (CompositeValue) metaValue;
      SimpleValue domain = (SimpleValue) compositeValue.get("domain");
      String domainUnwrap = (String) domain.getValue();
      MetaValue keys = compositeValue.get("keyPropertyList");
      Hashtable keysUnwrap = null;
      if(keys instanceof PropertiesMetaValue)
         keysUnwrap = (PropertiesMetaValue) keys;
      try
      {
         ObjectName name = new ObjectName(domainUnwrap, keysUnwrap);
         return name;
      }
      catch(Exception e)
      {
         throw new IllegalArgumentException(e);
      }
   }

}
