# Copyright (c) 2000-2007, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

%define _without_gcj_support 1

%define gcj_support %{?_with_gcj_support:1}%{!?_with_gcj_support:%{?_without_gcj_support:0}%{!?_without_gcj_support:%{?_gcj_support:%{_gcj_support}}%{!?_gcj_support:0}}}

%define _without_native 1
%define native      %{?_without_native:0}%{!?_without_native:1}

%bcond_with repolib
%define repodir %{_javadir}/repository.jboss.com/commons-daemon/commons-daemon/%{version}-brew 
%define repodirlib %{repodir}/lib
%define repodirsrc %{repodir}/src

%define base_name   daemon
%define short_name  commons-%{base_name}

Name:           jakarta-commons-daemon
Version:        1.0.5
Release:        2%{?dist}
Epoch:          1
Summary:        Defines API to support an alternative invocation mechanism
License:        ASL 2.0
Group:          Applications/System
URL:            http://commons.apache.org/daemon/
Source0:        http://www.apache.org/dist/commons/daemon/source/commons-daemon-1.0.5-src.tar.gz
%if %with repolib
Source2:	jakarta-commons-daemon-component-info.xml
%endif
Patch0:          %{name}-crosslink.patch
Patch1:          %{name}-execve-path-warning.patch
Patch2:          %{name}-config.patch
Patch3:          %{name}-location.patch
#Not needed for EAP build
#Patch2:          %{name}-ia64-configure.patch
#Patch3:          %{name}-s390x-configure.patch
#Patch4:          %{name}-ppc64-configure.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if %{native}
BuildRequires:  java-devel
BuildRequires:  xmlto
%endif
%if ! %{gcj_support}
BuildArch:      noarch
%endif
%if %with repolib
BuildRequires:   commons-build-plugin
BuildRequires:   maven-antrun-plugin
BuildRequires:   maven-assembly-plugin
BuildRequires:   maven-plugin-bundle
BuildRequires:   maven-compiler-plugin
BuildRequires:   maven-deploy-plugin
BuildRequires:   maven-idea-plugin
BuildRequires:   maven-jar-plugin
%endif
BuildRequires:  ant, java-javadoc
BuildRequires:  jpackage-utils >= 0:1.6
Provides:       %{short_name} = %{epoch}:%{version}-%{release}
Obsoletes:      %{short_name} < %{epoch}:%{version}-%{release}

%if %{gcj_support}
BuildRequires:       java-gcj-compat-devel
Requires(post):      java-gcj-compat
Requires(postun):    java-gcj-compat
%endif

#win-buildrequires: xbuild

%description
The scope of this package is to define an API in line with the current
Java(tm) Platform APIs to support an alternative invocation mechanism
which could be used instead of the above mentioned public static void
main(String[]) method.  This specification cover the behavior and life
cycle of what we define as Java(tm) daemons, or, in other words, non
interactive Java(tm) applications.

%if %with repolib
%package repolib
Summary:        Artifacts to be uploaded to a repository library
Group:          Development/Libraries/Java

%description repolib
Artifacts to be uploaded to a repository library.
This package is not meant to be installed but so its contents
can be extracted through rpm2cpio.
%endif

%package        jsvc
Summary:        Java daemon launcher
Group:          Applications/System
Provides:       jsvc = %{epoch}:%{version}-%{release}

%if %{gcj_support}
BuildRequires:       java-gcj-compat-devel
Requires(post):      java-gcj-compat
Requires(postun):    java-gcj-compat
%endif

%description    jsvc
%{summary}.

%package        javadoc
Summary:        Javadoc for %{name}
Group:          Documentation
Requires(post):   /bin/rm,/bin/ln
Requires(postun): /bin/rm

%description    javadoc
Javadoc for %{name}.


%prep
%setup -q -n %{short_name}-%{version}-src
%patch0 -p0
%patch1 -p1
%patch2 -p1
%patch3 -p1
#Not needed for EAP build
#%patch2 -p0
#%patch3 -p0 -b .s390x
#%patch4 -p0 -b .ppc
chmod 644 src/samples/*
%if %{native}
pushd src/native/unix
xmlto man man/jsvc.1.xml
popd
%endif
sed -i -e '2425s/powerpc/powerpc*/' src/native/unix/configure


%build
ant -Dant.lib=%{_javadir} -Dj2se.javadoc=%{_javadocdir}/java dist
%if %{native}
cd src/native/unix
%configure --with-java=%{java_home}
make %{?_smp_mflags}
%endif

%install
rm -rf $RPM_BUILD_ROOT
%if %{native}
install -Dpm 755 src/native/unix/jsvc $RPM_BUILD_ROOT%{_bindir}/jsvc
install -Dpm 0644 src/native/unix/jsvc.1 $RPM_BUILD_ROOT%{_mandir}/man1/jsvc.1
%endif
# jars
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}
install -pm 644 dist/%{short_name}-%{version}.jar \
  $RPM_BUILD_ROOT%{_javadir}/%{name}-%{version}.jar
(cd $RPM_BUILD_ROOT%{_javadir} && for jar in *-%{version}*; do ln -sf ${jar} `echo $jar| sed  "s|jakarta-||g"`; done)
(cd $RPM_BUILD_ROOT%{_javadir} && for jar in *-%{version}*; do ln -sf ${jar} `echo $jar| sed  "s|-%{version}||g"`; done)
# javadoc
install -d -m 755 $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}
cp -pr dist/docs/api/* $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}
ln -s %{name}-%{version} $RPM_BUILD_ROOT%{_javadocdir}/%{name}

# pom
mkdir -p $RPM_BUILD_ROOT%{_datadir}/maven2/poms
cp -p pom.xml $RPM_BUILD_ROOT%{_datadir}/maven2/poms/JPP-%{name}.pom
%add_to_maven_depmap commons-daemon commons-daemon %{version} JPP %{name}

%if %{gcj_support}
%{_bindir}/aot-compile-rpm
%endif

%if %with repolib
%{__mkdir_p} %{buildroot}%{repodir}

%{_bindir}/mvn-jpp deploy:deploy-file -DgroupId=commons-daemon -DartifactId=commons-daemon -Dversion=%{version} -Dfile=%{buildroot}%{_javadir}/jakarta-commons-daemon-%{version}.jar -DpomFile=%{buildroot}%{_datadir}/maven2/poms/JPP-%{name}.pom -Durl=file://%{buildroot}/usr/share/java/repository.jboss.com/maven2-brew/ -DrepositoryId=jboss-releases

%{__mkdir_p} %{buildroot}%{repodirlib}
%{__cp} -p %{SOURCE2} %{buildroot}%{repodir}/component-info.xml
tag=`/bin/echo %{name}-%{version}-%{release} | %{__sed} 's|\.|_|g'`
%{__sed} -i "s/@TAG@/$tag/g" %{buildroot}%{repodir}/component-info.xml
%{__sed} -i "s/@VERSION@/%{version}-brew/g" %{buildroot}%{repodir}/component-info.xml
%{__mkdir_p} %{buildroot}%{repodirsrc}
%{__cp} -p %{SOURCE0} %{buildroot}%{repodirsrc}
%{__cp} -p %{buildroot}%{_datadir}/maven2/poms/JPP-%{name}.pom %{buildroot}%{repodirlib}/%{name}.pom
%{__cp} -p %{buildroot}%{_javadir}/*.jar %{buildroot}%{repodirlib}/
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post
%update_maven_depmap
%if %{gcj_support}
if [ -x %{_bindir}/rebuild-gcj-db ]
then
  %{_bindir}/rebuild-gcj-db
fi
%endif

%postun
%update_maven_depmap
%if %{gcj_support}
if [ -x %{_bindir}/rebuild-gcj-db ]
then
  %{_bindir}/rebuild-gcj-db
fi
%endif

%if %{native}
%files jsvc
%defattr(-,root,root,-)
%doc LICENSE*
%{_bindir}/jsvc
%{_mandir}/man1/jsvc.1*
%endif

%files
%defattr(-,root,root,-)
%doc LICENSE.txt PROPOSAL.html NOTICE.txt RELEASE-NOTES.txt src/samples
%doc src/docs/*
%{_javadir}*/*
%{_datadir}/maven2/poms/JPP-%{name}.pom
%{_mavendepmapfragdir}/%{name}

%if %{gcj_support}
%attr(-,root,root) %{_libdir}/gcj/%{name}
%endif

%files javadoc
%defattr(-,root,root,-)
%doc %{_javadocdir}/%{name}-%{version}
%doc %{_javadocdir}/%{name}

%if %with repolib
%files repolib
%defattr(0644,root,root,0755)
%{_javadir}*/repository.jboss.com
%endif

%changelog
* Thu Jun  6 2011 Mladen Turk <mturk@redhat.com> - 1:1.0.5-2
- HP-UX rebuild

* Mon Jan 17 2011 Permaine Cheung <pcheung@redhat.com> - 1:1.0.5-1
- Upgrade to 1.0.5
- Adding missing BRs

* Tue Mar 24 2009 Permaine Cheung <pcheung@redhat.com> - 1:1.0.1-6.1
- Rebuild

* Mon Nov 03 2008 Fernando Nasser <fnasser@redhat.com> - 1:1.0.1-6
- Build without AOT

* Thu Aug 17 2006 Deepak Bhole <dbhole@redhat.com> - 1:1.0.1-6jpp.1
- Added missing requirements
- Fixed bug that cause post/postun to not run when built with --with native

* Thu Aug 10 2006 Karsten Hopp <karsten@redhat.de> 1.0.1-4jpp_3fc
- Requires(post):     coreutils

* Wed Jul 19 2006 Deepak Bhole <dbhole@redhat.com> - 1:1.0.1-4jpp_1fc
- Remove name/release/version defines as applicable.

* Mon Jul 17 2006 Deepak Bhole <dbhole@redhat.com> - 1:1.0.1-3jpp
- Added conditional native build.

* Wed Apr 12 2006 Ralph Apel <r.apel at r-apel.de> - 1:1.0.1-2jpp
- First JPP-1.7 release

* Thu Oct 27 2005 Ralph Apel <r.apel at r-apel.de> - 1:1.0.1-1jpp
- Update to 1.0.1

* Sun Aug 23 2004 Randy Watler <rwatler at finali.com> - 1:1.0-2jpp
- Rebuild with ant-1.6.2
* Tue May 18 2004 Ville Skyttä <ville.skytta at iki.fi> - 1:1.0-1jpp
- Update to 1.0.

* Sat Oct 11 2003 Ville Skyttä <ville.skytta at iki.fi> - 1:1.0-0.alpha.1jpp
- Update to 1.0 alpha, bump epoch.
- Non-versioned, crosslinked javadocs.
- Build native jsvc with "--with native".

* Thu Feb 27 2003 Henri Gomez <hgomez@users.sourceforge.net> 1.0-5jpp
- fix ASF license

* Thu Feb 27 2003 Henri Gomez <hgomez@users.sourceforge.net> 1.0-4jpp
- fix missing packager tag
- get latest nightly (20030227)
- fix ant lib location for javadoc
- added common-launcher jar

* Fri Jul 12 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0-3jpp
- clean up spec

* Mon Jun 10 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0-2jpp
- use sed instead of bash 2.x extension in link area to make spec compatible
  with distro using bash 1.1x

* Fri Jun 07 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0-1jpp 
- 1.0 (cvs 20020606)
- added short names in %{_javadir}, as does jakarta developpers
- first jPackage release
