# Copyright (c) 2000-2007, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#no jars in this native build, so skip signing
%define _jarsign_opts --nocopy

%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

%bcond_with repolib
%bcond_with tools
%if "%{?rhel}" == "6"
%bcond_without zips
%else
%bcond_with zips
%endif

%define repodir %{_javadir}/repository.jboss.com/apache-tomcat-connector-jk/%{version}-brew
%define repodirsrc %{repodir}/src

%{!?aprconf: %{expand: %%define aprconf %{_bindir}/apr-config}}
%if "%{?rhel}" == "7"
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs22}}
%{!?libtool: %{expand: %%define libtool %{_sysconfdir}/httpd22/build/libtool}}
%else
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs}}
%{!?libtool: %{expand: %%define libtool %{_sysconfdir}/httpd/build/libtool}}
%endif
%define aprincludes %(%{aprconf} --includes 2>/dev/null)

Name:      mod_jk
Epoch:     0
Version:   1.2.40
Release:   2%{?dist}
Summary:   Tomcat mod_jk connector for Apache

Group:     Internet/WWW/Servers
License:   ASL 2.0
URL:       http://tomcat.apache.org
Source0:   http://www.apache.org/dist/tomcat/tomcat-connectors/jk/tomcat-connectors-%{version}-src.tar.gz
Source1:   %{name}.conf.sample
Source2:   %{name}-component-info.xml
Source4:   workers.properties.sample
Patch0:    tomcat-connectors-1.2.40-BZ1100602.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if "%{?rhel}" == "7"
# 64 bit only natives on RHEL 7
ExcludeArch:   i386 i686
BuildRequires: httpd22-devel
%else
BuildRequires: httpd-devel
%endif
BuildRequires: perl
BuildRequires: ant-trax
%if "%{?rhel}" == "7"
BuildRequires:  java6-devel
%else
BuildRequires: java-devel >= 1.6.0
%endif
BuildRequires: jpackage-utils >= 0:1.5.38
BuildRequires: libtool
BuildRequires: xalan-j2 >= 2.7.0
BuildRequires: zip

#win-buildrequires: xbuild
#win-buildrequires: httpd
#sun-buildrequires: httpd

%description
Tomcat %{name} connector for Apache.

By default, this package builds %{name} for Apache 2.2.x. To build for
Apache 1.3.x, use the "--with apache1" option for the rpm build
command. To use a custom apxs, use "--define 'apxs /path/to/your/apxs'".
Additionally, for Apache 2.2.x, if your "apxs -q LIBTOOL" doesn't return
anything and the libtool that comes with Apache isn't located in
%{libtool}, use "--define 'libtool /path/to/your/libtool'".
To customize the apr-config executable used (not always needed), use
"--define 'aprconf /path/to/your/apr-config'".

%package ap22
Summary: Tomcat %{name} connector for Apache 2.x
Group: Internet/WWW/Servers
Provides: %{name} = %{epoch}:%{version}-%{release}
Obsoletes: tomcat-mod
Obsoletes: %{name}-ap20 < %{epoch}:%{version}
Obsoletes: mod_jk-tools < %{epoch}:%{version}-%{release}
%if "%{?rhel}" == "5"
Requires: httpd >= 2.2.3
Requires: mod_perl >= 2.0.4
%else
%if "%{?rhel}" == "6"
Requires: httpd >= 2.2.15
%else
%if "%{?rhel}" == "7"
Requires: httpd22 >= 2.2.15
%endif
%endif
%endif

%description ap22
Tomcat %{name} connector for Apache 2.x.

%package manual
Summary: Tomcat %{name} connector manual
Group: Internet/WWW/Servers

%description manual
Tomcat %{name} connector manual.

%if %with tools
%package tools
Group: Internet/Log Analysis
Summary: Analysis and report tools for %{name}

%description tools
Miscellaneous %{name} analysis and report tools.
%endif

%if %with zips
%package src-zip
Summary:     Container for the sources of the Tomcat %{name} connector.
Group:       Development

%description src-zip
Container for the sources of the Tomcat %{name} connector.
%endif

%if %with repolib
%package repolib
Summary:        Artifacts to be uploaded to a repository library
Group:          Development/Libraries/Java

%description repolib
Artifacts to be uploaded to a repository library.
This package is not meant to be installed but so its contents
can be extracted through rpm2cpio.
%endif

%prep
%setup -q -n tomcat-connectors-%{version}-src
%patch0 -p1 -b .bz1100602

%{__sed} -i -e 's|^(APXSCPPFLAGS=.*)$|$1 %{aprincludes}|' \
    native/common/Makefile.in

%build
%if %with zips
zip -q -r ../mod_jk-%{version}-src.zip *
%endif

pushd native
    [ -x ./configure ] || sh ./buildconf.sh
    %configure \
%if "%{?rhel}" == "7"
        --with-apxs="%{_sbindir}/apxs22"
    export LIBTOOL="`%{_sbindir}/apxs22 -q LIBTOOL 2>/dev/null`"
%else
        --with-apxs="%{_sbindir}/apxs"
    export LIBTOOL="`%{_sbindir}/apxs -q LIBTOOL 2>/dev/null`"
%endif
    # Handle old apxs (without -q LIBTOOL), eg Red Hat 8.0 and 9.
        if test -z "$LIBTOOL"; then
            LIBTOOL="%{libtool}"
        fi
    make %{?_smp_mflags} \
    LIBTOOL="$LIBTOOL" \
    EXTRA_CFLAGS="$RPM_OPT_FLAGS" \
    EXTRA_CPPFLAGS="%{aprincludes}"

popd
pushd xdocs
    CLASSPATH="$(build-classpath xalan-j2-serializer)" %ant
popd

%install
%{!?aprconf: %{expand: %%define aprconf %{_bindir}/apr-config}}
%if "%{?rhel}" == "7"
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs22}}
%{!?libtool: %{expand: %%define libtool %{_sysconfdir}/httpd22/build/libtool}}
%else
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs}}
%{!?libtool: %{expand: %%define libtool %{_sysconfdir}/httpd/build/libtool}}
%endif
%define aplibdir %(%{apxs} -q LIBEXECDIR 2>/dev/null)
%define apconfdir %(%{apxs} -q SYSCONFDIR 2>/dev/null)
%define aplogdir logs
%define aprincludes %(%{aprconf} --includes 2>/dev/null)
%define tc5dir %{_datadir}/tomcat5
%{__rm} -rf $RPM_BUILD_ROOT
install -p -m 0644 %{SOURCE1} %{SOURCE4} .
%{__mkdir} -p _ap20
%{__sed} -i -e 's|/usr/local/bin\b|%{_bindir}|' tools/reports/*.pl
command="s|/usr/local/bin\b|%{_bindir}|"
%{__sed} -i -e $command tools/reports/*.pl
%{__sed} -i -e 's|\@confdir\@|%{apconfdir}|' \
    -e 's|\@logdir\@|%{aplogdir}|' \
    -e 's|\@tomcatdir\@|%{tc5dir}|' \
    -e 's|\@java_home\@|%{java_home}|' \
    %{name}.conf.sample conf/workers.properties
%{__grep} -v ^AddModule %{name}.conf.sample > _ap20/%{name}.conf.sample
%{__install} -d -m 0755 ${RPM_BUILD_ROOT}/%{aplibdir}
%{__install} -p -m 0755 native/apache-2.0/%{name}.so \
        ${RPM_BUILD_ROOT}/%{aplibdir}/%{name}.so
%{__install} -d -m 0755 ${RPM_BUILD_ROOT}/%{_bindir}
%{__install} -d -m 0755 ${RPM_BUILD_ROOT}/%{_var}/run/%{name}
%{__install} -d -m 0755 ${RPM_BUILD_ROOT}/%{_var}/cache/%{name}
# for tools
%if %with tools
%{__install} -p -m 0755 tools/reports/*.pl ${RPM_BUILD_ROOT}/%{_bindir}
%endif

%if %with zips
%{__mkdir_p} ${RPM_BUILD_ROOT}%{_javadir}/jbossas-fordev
%{__install} ../mod_jk-%{version}-src.zip  ${RPM_BUILD_ROOT}%{_javadir}/jbossas-fordev/mod_jk-%{version}-src.zip
%endif

# repolib
%if %with repolib
        tag=`echo %{version}-brew`
        sed -i "s/@VERSION@/$tag/g" %{SOURCE2}
        tag=`echo %{name}-%{version}-%{release} | sed 's|\.|_|g'`
        sed -i "s/@TAG@/$tag/g" %{SOURCE2}
        install -d -m 755 $RPM_BUILD_ROOT%{repodir}
        install -d -m 755 $RPM_BUILD_ROOT%{repodirsrc}
        install -p -m 0644 %{SOURCE2} $RPM_BUILD_ROOT%{repodir}/component-info.xml
        install -m 755 %{SOURCE0} $RPM_BUILD_ROOT%{repodirsrc}
        install -m 755 %{SOURCE1} $RPM_BUILD_ROOT%{repodirsrc}
        install -m 755 %{SOURCE4} $RPM_BUILD_ROOT%{repodirsrc}
%endif

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files ap22
%if "%{?rhel}" == "7"
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs22}}
%else
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs}}
%endif
%define aplibdir %(%{apxs} -q LIBEXECDIR 2>/dev/null)
%defattr(-,root,root,-)
%doc LICENSE NOTICE _ap20/%{name}.conf.sample workers.properties.sample
%doc native/README.txt native/TODO.txt
%{aplibdir}/*
%dir %{_var}/run/%{name}
%dir %{_var}/cache/%{name}

%files manual
%defattr(0644,root,root,0755)
%doc build/docs/*

%if %with tools
%files tools
%defattr(-,root,root,-)
%doc tools/reports/README.txt
%{_bindir}/*
%endif

%if %with zips
%files src-zip
%defattr(0644,root,root,0755)
%{_javadir}/jbossas-fordev/mod_jk-%{version}-src.zip
%endif

%if %with repolib
%files repolib
%defattr(0644,root,root,0755)
%{_javadir}/repository.jboss.com
%endif

%changelog
* Mon Jun  2 2014 Mladen Turk <mturk@redhat.com> - 0:1.2.40-2
- Fix BZ1100602

* Tue Apr 29 2014 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.40-1
- Upgrade to mod_jk-1.2.40

* Thu Jun 20 2013 Mladen Turk <mturk@redhat.com> - 0:1.2.37-4
- Fix JBPAPP-10786

* Tue May 28 2013 Mladen Turk <mturk@redhat.com> - 0:1.2.37-3
- HP-UX rebuild

* Mon May  6 2013 Mladen Turk <mturk@redhat.com> - 0:1.2.37-2
- Add missing patch for JBPAPP-9703

* Fri Apr 26 2013 Mladen Turk <mturk@redhat.com> - 0:1.2.37-1
- Rebase to 1.2.37

* Wed Sep  5 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.36-9
- Fix JBPAPP-9703

* Mon May 28 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.36-8
- Fix JBPAPP-9164

* Mon May 21 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.36-7
- Fix JBPAPP-9052

* Mon May 21 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.36-6
- Fix JBPAPP-9052

* Wed May 16 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.36-5
- Fix JBPAPP-9024

* Tue May 15 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.36-2
- Try to fix JBPAPP-9024

* Mon May 14 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.36-1
- Upgrade to 1.2.36
- Remove patch for JBPAPP-8919 as it's incorporated into 1.2.36

* Sat May  5 2012 Mladen Turk <mturk@redhat.com> 0:1.2.35-3
- Fix JBPAPP-8919 by syncing with future 1.2.36.
  This patch will go away if we rebase to 1.2.36

* Tue Mar 27 2012 Mladen Turk <mturk@redhat.com> 0:1.2.35-2
- Fix solaris build for mod_jk-1.2.35

* Mon Mar 26 2012 Mladen Turk <mturk@redhat.com> 0:1.2.35-1
- Upgrade to mod_jk-1.2.35

* Wed Feb 29 2012 Vaclav Tunka <vtunka@redhat.com> 0:1.2.32-1
- Upgrade to mod_jk-1.2.32

* Wed Feb  1 2012 Mladen Turk <mturk@redhat.com> 0:1.2.31-8
- Rebuild using git repository.

* Sat Dec 10 2011 Mladen Turk <mturk@redhat.com> - 0:1.2.31-7
- Add missing httpd configuration samples

* Sat Dec 10 2011 Mladen Turk <mturk@redhat.com> - 0:1.2.31-6
- Fix isapi_redirect build on Win32

* Thu Dec  8 2011 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.31-5
- Build for EAP 6 / EWS 2

* Wed Oct 26 2011 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.31-4
- Rebuild

* Fri Oct 21 2011 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.31-3
- Makefile include for general xbuild Makefile
- Moving to generated .ini file

* Wed Oct 12 2011 Mladen Turk <mturk@redhat.com> - 0:1.2.31-2
- Add winspec files

* Thu Nov 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.2.31-1
- Update to 1.2.31

* Thu May 20 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.2.30-2
- Add repolib for sources

* Tue May 18 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.2.30-1
- Update to 1.2.30

* Fri May 07 2010 Martha Benitez <mbenitez@redhat.com> - 0:1.2.28-5.1
- rebuilt

* Tue Apr 06 2010 Hui Wang <huwang@redhat.com> - 0:1.2.28-5
- Rebuild

* Mon Jan 11 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.2.28-4
- Update sample files (from mmillson@redhat.com)

* Wed Jul 22 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.2.28-3
- Fix src-zip

* Wed Jul 22 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.2.28-2
- Add src-zip

* Wed Jul 22 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.2.28-1
- Update to 1.2.28
- Update sample configuration in docdir (Mike Millson, #490792)

* Mon Apr 27 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.2.27-5
- Obsoletes mod_jk-tools
- Do not build mod_jk-tools

* Tue Mar 24 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.2.27-4
- BR httpd22 instead of httpd

* Thu Mar 12 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.2.27-3
- Add patch for fixing broken links in docs

* Fri Jan 16 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.2.27-2
- Add patch for bz46352 (From Mladen Turk)

* Wed Dec 03 2008 Permaine Cheung <pcheung@redhat.com> - 0:1.2.27-1
- Update to 1.2.27

* Tue Mar 25 2008 Deepak Bhole <dbhole@redhat.com> - 0:1.2.26-1
- Update to 1.2.26

* Thu Jun 07 2007 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.23-3
- Own /var/run/mod_jk for shared memory segments etc. to be placed and
  avoid SELinux pains
- Resolves: bug 225452

* Mon Jun 04 2007 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.23-2.el5s2
- Fix mod_jk.conf
- Resolves: bug 229164

* Tue May 29 2007 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.23-1.el5s2
- Update to 1.2.23-1jpp
- Re-add some patches (pointer cast)
- Rename/merge -libtool-tag.patch
- Re-add jboss specific samples

* Thu May 03 2007 Deepak Bhole <dbhole@redhat.com> - 0:1.2.22-1.el5s2
- Update to 1.2.22
- Update patch names, and make the patch names use %%version in spec file
- Avoid use of ForwardURICompat in mod_jk.conf jboss sample, replaced with
  ForwardURICompatUnparsed. See bug 237656
- Use java-1.5.0-bea-devel to build

* Fri Apr 20 2007 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.21-1.el5s2
- Use new naming convention
- First rebuild for Stacks V2
- Add additional mod_jk.conf.jboss.sample and workers.properties.jboss.sample
  as references for users to use mod_jk with JBoss, detailed instructions can
  be found at: http://www.jboss.org/wiki/Wiki.jsp?page=UsingMod_jk1.2WithJBoss 
- Regenerate jni patch since the previous one no longer applied
  (note: we still dont build the JNI connectors)
- Rename the patches to signify switch to 1.2.21

* Mon Mar 05 2007 Fernando Nasser <fnasser@redhat.com> - 0:1.2.21-1.el4s1.1
- Upgrade

* Mon Mar 05 2007 Fernando Nasser <fnasser@redhat.com> - 0:1.2.21-1jpp
- Upgrade to 1.2.21
WARNING: Critical vulnerabilities in previous versions

* Mon Feb 26 2007 Vivek Lakshmanan <vivekl@redhat.com> 1.2.20-1.el4s1.2
- Add patch for jk_uri_worker_map from jclere
- Resolves: #230045

* Fri Jan 05 2007 Deepak Bhole <dbhole@redhat.com> 1.2.20-1.el4s1.1
- Upgrade to 1.2.20

* Fri Jan  5 2007 Ville Skyttä <scop at jpackage.org> - 0:1.2.20-1jpp
- 1.2.20.

* Wed Nov 29 2006 Deepak Bhole <dbhole@redhat.com> 1.2.19-1.el4s1.1
- Build into Stacks V1.1
- Disable JNI

* Tue Sep 19 2006 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.19-2jpp
- Remove unsupported JNI workers.

* Mon Sep 18 2006 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.19-1jpp
- Upgrade to version 1.2.19.
- Add versioned requirement on xalan-j2 (for xalan-j2-serializer).

* Fri Sep 15 2006 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.18-2jpp_7rh
- Rebuild.

* Mon Sep 11 2006 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.18-2jpp_6rh
- Rebuild.

* Mon Sep 11 2006 Vivek Lakshmanan <vivekl@redhat.com> - 0:1.2.18-2jpp_5rh
- Re-enable all patches for x86-64.

* Fri Aug 25 2006 Fernando Nasser <fnasser@redhat.com> - 0:1.2.18-2jpp_4rh
- Re-add x86_64

* Fri Aug 25 2006 Fernando Nasser <fnasser@redhat.com> - 0:1.2.18-2jpp_3rh
- Re-add other arches but for x86_64

* Fri Aug 25 2006 Fernando Nasser <fnasser@redhat.com> - 0:1.2.18-2jpp_2rh
- Rebuild excluding ppc ia64 x86_64

* Thu Aug 24 2006 Fernando Nasser <fnasser@redhat.com> - 0:1.2.18-2jpp_1rh
- Merge with upstream for upgrade

* Thu Aug 24 2006 Fernando Nasser <fnasser@redhat.com> - 0:1.2.18-2jpp
- Add header

* Tue Aug 22 2006 Ville Skyttä <scop at jpackage.org> - 0:1.2.18-1jpp
- 1.2.18.

* Thu Dec 22 2005 Ville Skyttä <scop at jpackage.org> - 0:1.2.15-1jpp
- 1.2.15.

* Mon Oct 24 2005 Jason Corley <jason.corley@gmail.com> - 0:1.2.14.1-2jpp
- Add xalan-j2 BuildRequires

* Thu Oct 13 2005 Ville Skyttä <scop at jpackage.org> - 0:1.2.14.1-1jpp
- 1.2.14.1.

* Mon Jun 27 2005 Thomas Fitzsimmons <fitzsim@redhat.com> - 0:1.2.6-3jpp_7rh
- Add fix for pointer cast warnings.

* Mon Jun 27 2005 Thomas Fitzsimmons <fitzsim@redhat.com> - 0:1.2.6-3jpp_6rh
- Remove jni_md.h check from configure.

* Wed Jun 22 2005 Fernando nasser <fnasser@redhat.com> - 0:1.2.6-3jpp_5rh
- Rebuild

* Mon Apr 18 2005 Jason Corley <jason.corley@gmail.com> - 0:1.2.10-1jpp
- 1.2.10

* Tue Feb 22 2005 Ville Skyttä <scop at jpackage.org> - 0:1.2.8-2jpp
- Revert *.pl interpreters to %%{__perl}.

* Fri Feb 18 2005 Ville Skyttä <scop at jpackage.org> - 0:1.2.8-1jpp
- 1.2.8.
- Build for Apache 2.x by default, "--with apache1" for Apache 1.3.x.

* Wed Feb 16 2005 Fernando nasser <fnasser@redhat.com> - 0:1.2.6-3jpp_3rh
- Add ppc64 and x86_64
- Rebuild

* Wed Feb 16 2005 Fernando nasser <fnasser@redhat.com> - 0:1.2.6-3jpp_2rh
- Rebuild

* Wed Dec 08 2004 Fernando nasser <fnasser@redhat.com> - 0:1.2.6-3jpp_1rh
- First Red Hat release
- Build by default for Apache 2.0.x
- Add --tag to remaining LIBTOOL invocations

* Mon Oct 4 2004 Nicolas Mailhot <nim@jpackage.org> - 0:1.2.6-3jpp
- do not apply RHES 2.1 libtool workaround to apache2 builds

* Mon Oct 4 2004 Nicolas Mailhot <nim@jpackage.org> - 0:1.2.6-2jpp
- Add RHES 2.1 libtool workaround

* Wed Sep 29 2004 Nicolas Mailhot <nim@jpackage.org> - 0:1.2.6-1jpp
- Update to 1.2.6 as per Henri's suggestion:
  "JK2 is not production ready"
- Change default target from Tomcat 4 to Tomcat 5. Tomcat 5.5 is out and 
  Tomcat 5 is now the official stable version
- initial built on RHES 3, RHES 2.1 and RH 7.3

* Sat Nov 15 2003 Ville Skyttä <scop at jpackage.org> - 0:1.2.5-2jpp
- Use apr-config if available for apache2 to allow building on FC1.
- Include README and CHANGES.txt in docs.

* Mon Oct 13 2003 Ville Skyttä <scop at jpackage.org> - 0:1.2.5-1jpp
- Update to 1.2.5 final.

* Thu Jul 24 2003 Ville Skyttä <scop at jpackage.org> - 0:1.2.5-0.1jpp
- Update to unofficial 1.2.5.

* Fri Jun 27 2003 Ville Skyttä <scop at jpackage.org> - 0:1.2.4-1jpp
- Use the libtool that comes with Apache 2 for building with it.
- Provide a fallback "--define 'libtool /path/to/your/libtool'".
- Thanks to Henri Gomez for the above fixes.

* Thu Jun 26 2003 Ville Skyttä <scop at jpackage.org> - 0:1.2.4-0.2jpp
- Add --with apache2 rpmbuild option.
- Add manual subpackage.

* Wed Jun 25 2003 Ville Skyttä <scop at jpackage.org> - 0:1.2.4-0.1jpp
- Made apxs customizable with
  "rpmbuild --rebuild --define 'apxs /path/to/your/apxs'".

* Wed Jun 25 2003 Ville Skyttä <scop at jpackage.org> - 0:1.2.4-0jpp
- Update to 1.2.4, massive spec cleanup (only mod_jk for Apache 1.3 now).

* Tue Dec 17 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.2.2-1jpp
- jtc 1.2.2
- add Obsoletes tomcat-mod

* Tue Nov 26 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.2.1-1jpp
- jtc 1.2.1
- add package mod_jk-tools (require gd 1.8.x and perl modules GD 1.4.1, 
  GD Graph, GD TextUtil  and StatisticsDescriptive)

* Tue Oct 08 2002 Henri Gomez <hgomez@users.sourceforge.net> 2.0.1-1jpp
- jtc snapshot from JK 2.0.1 beta release
- apr / apr-util / apr-devel packages required for JK2 build and Apache 1.3,
  you could find them at : http://ftp.falsehope.com/home/gomez/apr/
- apache2 / apache2-devel packages required Apache 2 build,
  you could find them at : http://ftp.falsehope.com/home/gomez/apache2/

* Fri Oct 04 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.2.0-2jpp
- jtc 1.2.0 built against Apache 2.0.43

* Wed Oct 02 2002 Henri Gomez <hgomez@users.sourceforge.net> 2.0.0-1jpp
- jtc snapshot from JK 2.0.0 beta release
- apr / apr-util / apr-devel packages required for JK2 build and Apache 1.3,
  you could find them at : http://ftp.falsehope.com/home/gomez/apr/
- apache2 / apache2-devel packages required Apache 2 build,
  you could find them at : http://ftp.falsehope.com/home/gomez/apache2/

* Wed Sep 25 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0.jk1.2.0-1jpp
- jtc snapshot from JK 1.2.0 release

* Thu Aug 22 2002 Henri Gomez <hgomez@users.sourceforge.net> 1.0.4.1.9-1jpp
- jtc snapshot from tomcat 4.1.9 beta
- webapp not build since it requires autoconf > 2.5 not available in rpm distribs 

* Thu Feb 14 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Initial tomcat-connectors release
- use the jakarta-tomcat-connectors-4.0.2-01-src 
  (which correct some auth problems with ajp13)

