/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.jaxrs.provider.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.activation.DataSource;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.apache.http.entity.StringEntity;

/**
 * @author baranowb
 * 
 *
 */
@Path("/upload")
public class RestConsumer {
    public static final String PATH_UPLOAD = "/upload";

    @POST
    @Produces("text/plain")
    public Response read(final DataSource ds) throws Exception {

        final String content1 = readStream(ds);
        final String content2 = readStream(ds);
        if (content1.equals(content2)) {
            return Response.ok().build();
        } else {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR)
                    .entity(new StringEntity("Content from second read does not match content from first read")).build();
        }

    }

    private BufferedReader getReader(final DataSource ds) throws IOException {
        return new BufferedReader(new InputStreamReader(ds.getInputStream()));
    }

    private String readStream(final DataSource ds) throws IOException {
        final StringBuilder stringBuilder = new StringBuilder(4100);
        final BufferedReader bufferedReader = getReader(ds);
        try {
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        } finally {
            bufferedReader.close();
        }
    }
}
