/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String STATEMANAGED_SERIAL_ID_KEY = StateManagerImpl.class.getName() + ".SerialId";
    private static final String LOGICAL_VIEW_MAP = "com.sun.faces.logicalViewMap";
    private SerializationProvider serialProvider;
    private WebConfiguration webConfig;
    private int noOfViews;
    private int noOfViewsInLogicalView;
    private boolean compressViewState;
    private Map<String, Class<?>> classMap = new ConcurrentHashMap(32);
    private Random random;
    private boolean generateUniqueStateIds;

    public StateManagerImpl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.serialProvider = SerializationProviderFactory.createInstance(facesContext.getExternalContext());
        this.webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
        if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DevelopmentMode)) {
            this.classMap = new ConcurrentHashMap(32);
        }
        this.generateUniqueStateIds = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.GenerateUniqueServerStateIds);
        this.random = this.generateUniqueStateIds ? new Random(System.nanoTime() + (long)this.webConfig.getServletContext().hashCode()) : null;
        this.compressViewState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        UIViewRoot uIViewRoot = null;
        if (this.isSavingStateInClient(facesContext)) {
            uIViewRoot = this.restoreTree(facesContext, string, string2);
            if (uIViewRoot != null) {
                this.restoreState(facesContext, uIViewRoot, string2);
            }
        } else {
            Object object;
            ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string2);
            Object object2 = this.hasGetStateMethod(responseStateManager) ? ((object = (Object[])responseStateManager.getState(facesContext, string)) != null ? object[0] : null) : responseStateManager.getTreeStructureToRestore(facesContext, string);
            if (null != object2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Begin restoring view in session for viewId " + string);
                }
                object = (String)object2;
                int n = ((String)object).indexOf(58);
                assert (-1 != n);
                assert (n < ((String)object).length());
                String string3 = ((String)object).substring(0, n);
                String string4 = ((String)object).substring(n + 1);
                ExternalContext externalContext = facesContext.getExternalContext();
                Object object3 = externalContext.getSession(false);
                if (object3 == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Can't Restore Server View State, session expired for viewId: " + string);
                    }
                    return null;
                }
                Object[] objectArray = null;
                Object object4 = object3;
                synchronized (object4) {
                    Map map;
                    Map map2 = (Map)externalContext.getSessionMap().get(LOGICAL_VIEW_MAP);
                    if (map2 != null && (map = (Map)map2.get(string3)) != null) {
                        RequestStateManager.set(facesContext, LOGICAL_VIEW_MAP, string3);
                        if (responseStateManager.isPostback(facesContext)) {
                            RequestStateManager.set(facesContext, "com.sun.faces.actualViewMap", string4);
                        }
                        objectArray = (Object[])map.get(string4);
                    }
                }
                if (objectArray == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Session Available, but View State does not exist for viewId: " + string);
                    }
                    return null;
                }
                uIViewRoot = this.restoreTree((Object[])((Object[])objectArray[0]).clone());
                uIViewRoot.processRestoreState(facesContext, this.handleRestoreState(objectArray[1]));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("End restoring view in session for viewId " + string);
                }
            }
        }
        return uIViewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext facesContext) {
        StateManager.SerializedView serializedView = null;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot.isTransient()) {
            return serializedView;
        }
        this.checkIdUniqueness(facesContext, (UIComponent)uIViewRoot, new HashSet<String>(uIViewRoot.getChildCount() << 1));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Begin creating serialized view for " + uIViewRoot.getViewId());
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(32);
        Object object = uIViewRoot.processSaveState(facesContext);
        StateManagerImpl.captureChild(arrayList, 0, (UIComponent)uIViewRoot);
        Object[] objectArray = arrayList.toArray();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("End creating serialized view " + uIViewRoot.getViewId());
        }
        if (!this.isSavingStateInClient(facesContext)) {
            int n = this.getNumberOfViewsParameter();
            int n2 = this.getNumberOfViewsInLogicalViewParameter();
            ExternalContext externalContext = facesContext.getExternalContext();
            Object object2 = externalContext.getSession(true);
            Map map = externalContext.getSessionMap();
            Object object3 = object2;
            synchronized (object3) {
                String string;
                Map<String, Map> map2 = TypedCollections.dynamicallyCastMap((Map)map.get(LOGICAL_VIEW_MAP), String.class, Map.class);
                if (map2 == null) {
                    map2 = new LRUMap<String, Map>(n);
                    map.put(LOGICAL_VIEW_MAP, map2);
                }
                if ((string = (String)RequestStateManager.get(facesContext, LOGICAL_VIEW_MAP)) == null) {
                    String string2 = string = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(facesContext);
                }
                assert (null != string);
                String string3 = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(facesContext);
                Map<String, Object[]> map3 = TypedCollections.dynamicallyCastMap(map2.get(string), String.class, Object[].class);
                if (map3 == null) {
                    map3 = new LRUMap<String, Object[]>(n2);
                    map2.put(string, map3);
                }
                String string4 = string + ':' + string3;
                serializedView = new StateManager.SerializedView((StateManager)this, (Object)string4, null);
                Object[] objectArray2 = map3.get(string3);
                if (objectArray2 != null) {
                    objectArray2[0] = objectArray;
                    objectArray2[1] = this.handleSaveState(object);
                } else {
                    map3.put(string3, new Object[]{objectArray, this.handleSaveState(object)});
                }
                map.put(LOGICAL_VIEW_MAP, map2);
            }
        } else {
            serializedView = new StateManager.SerializedView((StateManager)this, (Object)objectArray, object);
        }
        return serializedView;
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        String string = facesContext.getViewRoot().getRenderKitId();
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string);
        if (this.hasGetStateMethod(responseStateManager)) {
            Object[] objectArray = new Object[]{serializedView.getStructure(), serializedView.getState()};
            responseStateManager.writeState(facesContext, (Object)objectArray);
        } else {
            responseStateManager.writeState(facesContext, serializedView);
        }
    }

    protected void checkIdUniqueness(FacesContext facesContext, UIComponent uIComponent, Set<String> set) throws IllegalStateException {
        Iterator iterator = uIComponent.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            String string = uIComponent2.getClientId(facesContext);
            if (set.add(string)) {
                this.checkIdUniqueness(facesContext, uIComponent2, set);
                continue;
            }
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", string);
            }
            FastStringWriter fastStringWriter = new FastStringWriter(128);
            DebugUtil.simplePrintTree((UIComponent)facesContext.getViewRoot(), string, fastStringWriter);
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", string) + '\n' + fastStringWriter.toString();
            throw new IllegalStateException(string2);
        }
    }

    protected int getNumberOfViewsInLogicalViewParameter() {
        if (this.noOfViewsInLogicalView != 0) {
            return this.noOfViewsInLogicalView;
        }
        String string = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfLogicalViews);
        String string2 = WebConfiguration.WebContextInitParameter.NumberOfLogicalViews.getDefaultValue();
        try {
            this.noOfViewsInLogicalView = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Error parsing the servetInitParameter " + WebConfiguration.WebContextInitParameter.NumberOfLogicalViews.getQualifiedName() + ". Using default " + this.noOfViewsInLogicalView);
            }
            try {
                this.noOfViewsInLogicalView = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        return this.noOfViewsInLogicalView;
    }

    protected int getNumberOfViewsParameter() {
        if (this.noOfViews != 0) {
            return this.noOfViews;
        }
        String string = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfViews);
        String string2 = WebConfiguration.WebContextInitParameter.NumberOfViews.getDefaultValue();
        try {
            this.noOfViews = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Error parsing the servetInitParameter " + WebConfiguration.WebContextInitParameter.NumberOfViews.getQualifiedName() + ". Using default " + this.noOfViews);
            }
            try {
                this.noOfViews = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        return this.noOfViews;
    }

    private Object handleSaveState(Object object) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = this.serialProvider.createObjectOutputStream(this.compressViewState ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, 1024) : byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
            finally {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        return object;
    }

    private Object handleRestoreState(Object object) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = this.serialProvider.createObjectInputStream(this.compressViewState ? new GZIPInputStream((InputStream)byteArrayInputStream, 1024) : byteArrayInputStream);
                Object object2 = objectInputStream.readObject();
                return object2;
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return object;
    }

    private String createIncrementalRequestId(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getSessionMap();
        AtomicInteger atomicInteger = (AtomicInteger)map.get(STATEMANAGED_SERIAL_ID_KEY);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(1);
        }
        map.put(STATEMANAGED_SERIAL_ID_KEY, atomicInteger);
        return "j_id" + atomicInteger.getAndIncrement();
    }

    private String createRandomId() {
        return Long.valueOf(this.random.nextLong()).toString();
    }

    private static void captureChild(List<TreeNode> list, int n, UIComponent uIComponent) {
        if (!uIComponent.isTransient()) {
            TreeNode treeNode = new TreeNode(n, uIComponent);
            int n2 = list.size();
            list.add(treeNode);
            StateManagerImpl.captureRest(list, n2, uIComponent);
        }
    }

    private static void captureFacet(List<TreeNode> list, int n, String string, UIComponent uIComponent) {
        if (!uIComponent.isTransient()) {
            FacetNode facetNode = new FacetNode(n, string, uIComponent);
            int n2 = list.size();
            list.add(facetNode);
            StateManagerImpl.captureRest(list, n2, uIComponent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void captureRest(List<TreeNode> list, int n, UIComponent uIComponent) {
        int n2 = uIComponent.getChildCount();
        if (n2 > 0) {
            void entry;
            List list2 = uIComponent.getChildren();
            boolean i = false;
            while (entry < n2) {
                StateManagerImpl.captureChild(list, n, (UIComponent)list2.get((int)entry));
                ++entry;
            }
        }
        if ((n2 = uIComponent.getFacetCount()) > 0) {
            for (Map.Entry entry : uIComponent.getFacets().entrySet()) {
                StateManagerImpl.captureFacet(list, n, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    private boolean hasGetStateMethod(ResponseStateManager responseStateManager) {
        return ReflectionUtils.lookupMethod(responseStateManager.getClass(), "getState", FacesContext.class, String.class) != null;
    }

    private UIComponent newInstance(TreeNode treeNode) throws FacesException {
        try {
            Class clazz;
            Class clazz2 = clazz = this.classMap != null ? this.classMap.get(treeNode.componentType) : null;
            if (clazz == null) {
                clazz = Util.loadClass(treeNode.componentType, treeNode);
                if (clazz != null && this.classMap != null) {
                    this.classMap.put(treeNode.componentType, clazz);
                } else {
                    throw new NullPointerException();
                }
            }
            UIComponent uIComponent = (UIComponent)clazz.newInstance();
            uIComponent.setId(treeNode.id);
            return uIComponent;
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private UIViewRoot restoreTree(FacesContext facesContext, String string, String string2) {
        Object[] objectArray;
        UIViewRoot uIViewRoot;
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string2);
        if (this.hasGetStateMethod(responseStateManager)) {
            uIViewRoot = (UIViewRoot)responseStateManager.getState(facesContext, string);
            if (uIViewRoot == null) {
                return null;
            }
            objectArray = (Object[])uIViewRoot[0];
        } else {
            objectArray = (Object[])responseStateManager.getTreeStructureToRestore(facesContext, string);
        }
        if (objectArray == null) {
            return null;
        }
        uIViewRoot = this.restoreTree(objectArray);
        uIViewRoot.setViewId(string);
        return uIViewRoot;
    }

    private String createUniqueRequestId(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getSessionMap();
        AtomicInteger atomicInteger = (AtomicInteger)map.get(STATEMANAGED_SERIAL_ID_KEY);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(1);
        }
        map.put(STATEMANAGED_SERIAL_ID_KEY, atomicInteger);
        return "j_id" + atomicInteger.getAndIncrement();
    }

    private void restoreState(FacesContext facesContext, UIViewRoot uIViewRoot, String string) {
        Object object;
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string);
        if (ReflectionUtils.lookupMethod(responseStateManager.getClass(), "getState", FacesContext.class, String.class) != null) {
            Object[] objectArray = (Object[])responseStateManager.getState(facesContext, uIViewRoot.getViewId());
            object = objectArray[1];
        } else {
            object = responseStateManager.getComponentStateToRestore(facesContext);
        }
        uIViewRoot.processRestoreState(facesContext, object);
    }

    private UIViewRoot restoreTree(Object[] objectArray) throws FacesException {
        for (int i = 0; i < objectArray.length; ++i) {
            UIComponent uIComponent;
            if (objectArray[i] instanceof FacetNode) {
                FacetNode facetNode = (FacetNode)objectArray[i];
                uIComponent = this.newInstance(facetNode);
                objectArray[i] = uIComponent;
                if (i == facetNode.parent) continue;
                ((UIComponent)objectArray[facetNode.parent]).getFacets().put(facetNode.facetName, uIComponent);
                continue;
            }
            TreeNode treeNode = (TreeNode)objectArray[i];
            uIComponent = this.newInstance(treeNode);
            objectArray[i] = uIComponent;
            if (i == treeNode.parent) continue;
            ((UIComponent)objectArray[treeNode.parent]).getChildren().add(uIComponent);
        }
        return (UIViewRoot)objectArray[0];
    }

    private static final class FacetNode
    extends TreeNode {
        public String facetName;
        private static final long serialVersionUID = -3777170310958005106L;

        public FacetNode() {
        }

        public FacetNode(int n, String string, UIComponent uIComponent) {
            super(n, uIComponent);
            this.facetName = string;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.facetName = objectInput.readUTF();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeUTF(this.facetName);
        }
    }

    private static class TreeNode
    implements Externalizable {
        private static final String NULL_ID = "";
        public String componentType;
        public String id;
        public int parent;
        private static final long serialVersionUID = -835775352718473281L;

        public TreeNode() {
        }

        public TreeNode(int n, UIComponent uIComponent) {
            this.parent = n;
            this.id = uIComponent.getId();
            this.componentType = uIComponent.getClass().getName();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.parent);
            objectOutput.writeUTF(this.componentType);
            if (this.id != null) {
                objectOutput.writeUTF(this.id);
            } else {
                objectOutput.writeUTF(NULL_ID);
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.parent = objectInput.readInt();
            this.componentType = objectInput.readUTF();
            this.id = objectInput.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }
    }
}

