/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.ELUtils;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.util.FacesLogger;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class ELResolverInitPhaseListener
implements PhaseListener {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private boolean postInitCompleted;
    private boolean preInitCompleted;

    public synchronized void afterPhase(PhaseEvent phaseEvent) {
        if (!this.postInitCompleted) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Iterator iterator = lifecycleFactory.getLifecycleIds();
            while (iterator.hasNext()) {
                Lifecycle lifecycle = lifecycleFactory.getLifecycle((String)iterator.next());
                lifecycle.removePhaseListener((PhaseListener)this);
            }
            this.postInitCompleted = true;
        }
    }

    public synchronized void beforePhase(PhaseEvent phaseEvent) {
        if (!this.preInitCompleted) {
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
            applicationAssociate.setRequestServiced();
            applicationAssociate.initializeELResolverChains();
            applicationAssociate.installProgrammaticallyAddedResolvers();
            this.preInitCompleted = true;
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected void populateFacesELResolverForJsp(FacesContext facesContext) {
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(facesContext.getExternalContext());
        ELResolverInitPhaseListener.populateFacesELResolverForJsp(facesContext.getApplication(), applicationAssociate);
    }

    public static void populateFacesELResolverForJsp(Application application, ApplicationAssociate applicationAssociate) {
        FacesCompositeELResolver facesCompositeELResolver = applicationAssociate.getFacesELResolverForJsp();
        if (facesCompositeELResolver == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.lifecycle.initphaselistener.resolvers_not_registered", new Object[]{applicationAssociate.getContextName()});
            }
            return;
        }
        ELUtils.buildJSPResolver(facesCompositeELResolver, applicationAssociate);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.lifecycle.initphaselistener.resolvers_registered", new Object[]{applicationAssociate.getContextName()});
        }
    }

    public static void removeELResolverInitPhaseListener() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator iterator = lifecycleFactory.getLifecycleIds();
        while (iterator.hasNext()) {
            Lifecycle lifecycle = lifecycleFactory.getLifecycle((String)iterator.next());
            for (PhaseListener phaseListener : lifecycle.getPhaseListeners()) {
                if (!(phaseListener instanceof ELResolverInitPhaseListener)) continue;
                lifecycle.removePhaseListener(phaseListener);
            }
        }
    }
}

