/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ConverterPropertyEditorBase;
import com.sun.faces.application.ConverterPropertyEditorFor_XXXX;
import com.sun.faces.util.FacesLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterPropertyEditorFactory {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private static final Pattern UnderscorePattern = Pattern.compile("_+");
    private static final Pattern SingleUnderscorePattern = Pattern.compile("([^_])_([^_])");
    private static final Pattern MultipleUnderscorePattern = Pattern.compile("_(_+)");
    private static ConverterPropertyEditorFactory defaultInstance;
    private ClassTemplateInfo templateInfo;
    private Map<ClassLoader, WeakReference<DisposableClassLoader>> classLoaderCache;
    private static final Map<Character, String> PRIM_MAP;

    public ConverterPropertyEditorFactory() {
        this.templateInfo = new ClassTemplateInfo();
    }

    public ConverterPropertyEditorFactory(Class<? extends ConverterPropertyEditorBase> clazz) {
        this.templateInfo = new ClassTemplateInfo(clazz);
    }

    public static synchronized ConverterPropertyEditorFactory getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ConverterPropertyEditorFactory();
        }
        return defaultInstance;
    }

    private ClassTemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public Class<? extends ConverterPropertyEditorBase> definePropertyEditorClassFor(final Class<?> clazz) {
        try {
            DisposableClassLoader disposableClassLoader;
            WeakReference<DisposableClassLoader> weakReference;
            String string = this.getTemplateInfo().generateClassNameFor(clazz, false);
            if (this.classLoaderCache == null) {
                this.classLoaderCache = new WeakHashMap<ClassLoader, WeakReference<DisposableClassLoader>>();
            }
            if ((weakReference = this.classLoaderCache.get(clazz.getClassLoader())) == null || (disposableClassLoader = (DisposableClassLoader)weakReference.get()) == null) {
                disposableClassLoader = (DisposableClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new DisposableClassLoader(clazz.getClassLoader());
                    }
                });
                if (disposableClassLoader == null) {
                    return null;
                }
                this.classLoaderCache.put(clazz.getClassLoader(), new WeakReference<DisposableClassLoader>(disposableClassLoader));
            }
            return disposableClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "definePropertyEditorClassFor: ClassNotFoundException: " + classNotFoundException.getMessage(), classNotFoundException);
            return null;
        }
    }

    private static String getVMClassName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    private static byte[] getUtf8InfoBytes(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        byte[] byArray2 = new byte[byArray.length + 3];
        byArray2[0] = 1;
        byArray2[1] = (byte)(byArray.length >> 8 & 0xFF);
        byArray2[2] = (byte)(byArray.length & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 3, byArray.length);
        return byArray2;
    }

    static {
        PRIM_MAP = new HashMap<Character, String>(8, 1.0f);
        PRIM_MAP.put(Character.valueOf('B'), "byte");
        PRIM_MAP.put(Character.valueOf('C'), "char");
        PRIM_MAP.put(Character.valueOf('S'), "short");
        PRIM_MAP.put(Character.valueOf('I'), "int");
        PRIM_MAP.put(Character.valueOf('F'), "float");
        PRIM_MAP.put(Character.valueOf('J'), "long");
        PRIM_MAP.put(Character.valueOf('D'), "double");
        PRIM_MAP.put(Character.valueOf('Z'), "boolean");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisposableClassLoader
    extends ClassLoader {
        private ClassLoader targetLoader;
        private ClassLoader myLoader;

        public DisposableClassLoader(ClassLoader classLoader) {
            super(classLoader);
            this.targetLoader = classLoader;
            this.myLoader = ConverterPropertyEditorBase.class.getClassLoader();
        }

        @Override
        protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null && this.myLoader != null && this.myLoader != this.targetLoader) {
                try {
                    clazz = this.myLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = super.loadClass(string, false);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            String string2 = ConverterPropertyEditorFactory.this.getTemplateInfo().getTargetClassName(string);
            if (string2 != null) {
                byte[] byArray = ConverterPropertyEditorFactory.this.getTemplateInfo().generateClassBytesFor(string.replace('.', '/'), string2.replace('.', '/'));
                Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Defined editorClass " + clazz);
                }
                return clazz;
            }
            return super.findClass(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassTemplateInfo {
        private Class<? extends ConverterPropertyEditorBase> templateClass;
        private byte[] templateBytes;
        private int constant_pool_count;
        private Utf8InfoRef classNameConstant;
        private Utf8InfoRef classNameRefConstant;
        private Utf8InfoRef targetClassConstant;

        public ClassTemplateInfo() {
            this(ConverterPropertyEditorFor_XXXX.class);
        }

        public ClassTemplateInfo(Class<? extends ConverterPropertyEditorBase> clazz) {
            block2: {
                this.templateClass = clazz;
                try {
                    ConverterPropertyEditorBase converterPropertyEditorBase = clazz.newInstance();
                    Class<?> clazz2 = converterPropertyEditorBase.getTargetClass();
                    this.loadTemplateBytes();
                    this.classNameConstant = this.findConstant(ConverterPropertyEditorFactory.getVMClassName(clazz));
                    this.classNameRefConstant = this.findConstant(new StringBuilder(64).append('L').append(ConverterPropertyEditorFactory.getVMClassName(clazz)).append(';').toString());
                    this.targetClassConstant = this.findConstant(ConverterPropertyEditorFactory.getVMClassName(clazz2));
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block2;
                    LOGGER.log(Level.FINE, "Unexected exception ClassTemplateInfo", exception);
                }
            }
        }

        private boolean matchAtIndex(byte[] byArray, int n) {
            if (n < 0 || n + byArray.length > this.templateBytes.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == this.templateBytes[n + i]) continue;
                return false;
            }
            return true;
        }

        private Utf8InfoRef findConstant(String string) {
            byte[] byArray = ConverterPropertyEditorFactory.getUtf8InfoBytes(string);
            assert (byArray[0] == 1);
            int n = 10;
            block6: for (int i = 1; i < this.constant_pool_count && n < this.templateBytes.length; ++i) {
                if (this.matchAtIndex(byArray, n)) {
                    return new Utf8InfoRef(n, byArray.length);
                }
                switch (this.templateBytes[n]) {
                    case 1: {
                        int n2 = (this.templateBytes[n + 1] & 0xFF00) + (this.templateBytes[n + 2] & 0xFF);
                        n += 3 + n2;
                        continue block6;
                    }
                    case 7: 
                    case 8: {
                        n += 3;
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        n += 5;
                        continue block6;
                    }
                    case 5: 
                    case 6: {
                        n += 9;
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized class file constant pool tag " + this.templateBytes[n]);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadTemplateBytes() throws IOException {
            String string = '/' + this.templateClass.getName().replace('.', '/') + ".class";
            InputStream inputStream = ConverterPropertyEditorFactory.class.getResourceAsStream(string);
            if (inputStream != null) {
                try {
                    int n;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    this.templateBytes = byteArrayOutputStream.toByteArray();
                    assert (this.templateBytes.length > 9);
                    assert (this.templateBytes[0] == -54);
                    assert (this.templateBytes[1] == -2);
                    assert (this.templateBytes[2] == -70);
                    assert (this.templateBytes[3] == -66);
                    this.constant_pool_count = ((this.templateBytes[8] & 0xFF) << 8) + (this.templateBytes[9] & 0xFF);
                }
                finally {
                    inputStream.close();
                }
            }
        }

        public String generateClassNameFor(Class<?> clazz, boolean bl) {
            String string = clazz.getName();
            if (clazz.isArray()) {
                int n = string.lastIndexOf(91);
                int n2 = n + 1;
                int n3 = string.indexOf(59);
                string = n3 == -1 ? (String)PRIM_MAP.get(Character.valueOf(string.charAt(n + 1))) : string.substring(n + 2, n3);
                string = string + "Array" + n2 + 'd';
            }
            Matcher matcher = UnderscorePattern.matcher(string);
            string = matcher.replaceAll("$0_");
            string = string.replace('.', '_');
            if (bl) {
                return ConverterPropertyEditorFactory.getVMClassName(this.templateClass).replace("XXXX", string);
            }
            return this.templateClass.getName().replace("XXXX", string);
        }

        public String getTargetClassName(String string) {
            String string2 = this.templateClass.getName().replace("XXXX", "");
            if (string.startsWith(string2)) {
                String string3 = string.substring(string2.length());
                string3 = SingleUnderscorePattern.matcher(string3).replaceAll("$1.$2");
                string3 = MultipleUnderscorePattern.matcher(string3).replaceAll("$1");
                return string3;
            }
            return null;
        }

        private byte[] replaceInTemplate(Utf8InfoReplacement ... utf8InfoReplacementArray) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TreeSet<Utf8InfoReplacement> treeSet = new TreeSet<Utf8InfoReplacement>();
            for (Utf8InfoReplacement utf8InfoReplacement : utf8InfoReplacementArray) {
                if (utf8InfoReplacement.ref == null || utf8InfoReplacement.replacement == null) continue;
                treeSet.add(utf8InfoReplacement);
            }
            int n = 0;
            for (Utf8InfoReplacement utf8InfoReplacement : treeSet) {
                byteArrayOutputStream.write(this.templateBytes, n, utf8InfoReplacement.ref.index - n);
                n = utf8InfoReplacement.ref.index + utf8InfoReplacement.ref.length;
                byteArrayOutputStream.write(utf8InfoReplacement.replacement, 0, utf8InfoReplacement.replacement.length);
            }
            byteArrayOutputStream.write(this.templateBytes, n, this.templateBytes.length - n);
            return byteArrayOutputStream.toByteArray();
        }

        public byte[] generateClassBytesFor(String string, String string2) {
            return this.replaceInTemplate(new Utf8InfoReplacement(this.classNameConstant, string), new Utf8InfoReplacement(this.classNameRefConstant, new StringBuilder(32).append('L').append(string).append(';').toString()), new Utf8InfoReplacement(this.targetClassConstant, string2));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Utf8InfoReplacement
        implements Comparable<Utf8InfoReplacement> {
            Utf8InfoRef ref;
            byte[] replacement;

            public Utf8InfoReplacement(Utf8InfoRef utf8InfoRef, String string) {
                this.ref = utf8InfoRef;
                this.replacement = ConverterPropertyEditorFactory.getUtf8InfoBytes(string);
            }

            @Override
            public int compareTo(Utf8InfoReplacement utf8InfoReplacement) {
                return this.ref.index - utf8InfoReplacement.ref.index;
            }
        }

        private static class Utf8InfoRef {
            int index;
            int length;

            public Utf8InfoRef(int n, int n2) {
                this.index = n;
                this.length = n2;
            }
        }
    }
}

