/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.RIConstants;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifier {
    private static final ThreadLocal<Verifier> VERIFIER = new ThreadLocal();
    private List<String> messages = new ArrayList<String>(4);

    Verifier() {
    }

    public static Verifier getCurrentInstance() {
        return VERIFIER.get();
    }

    public static void setCurrentInstance(Verifier verifier) {
        if (verifier == null) {
            VERIFIER.remove();
        } else {
            VERIFIER.set(verifier);
        }
    }

    public boolean isApplicationValid() {
        return this.messages.isEmpty();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void validateObject(ObjectType objectType, String string, Class<?> clazz) {
        Class clazz2 = null;
        try {
            clazz2 = Util.loadClass(string, this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.CLASS_NOT_FOUND", new Object[]{objectType, string}));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.CLASS_MISSING_DEP", new Object[]{objectType, string, noClassDefFoundError.getMessage()}));
        }
        if (clazz2 != null) {
            try {
                Constructor constructor = clazz2.getConstructor(RIConstants.EMPTY_CLASS_ARGS);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.NON_PUBLIC_DEF_CTOR", new Object[]{objectType, string}));
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.NO_DEF_CTOR", new Object[]{objectType, string}));
            }
            if (!clazz.isAssignableFrom(clazz2)) {
                this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.WRONG_TYPE", new Object[]{objectType, string}));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectType {
        COMPONENT,
        CONVERTER,
        VALIDATOR;

    }
}

