/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mgbean;

import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.ErrorBean;
import com.sun.faces.mgbean.ManagedBeanBuilder;
import com.sun.faces.mgbean.ManagedBeanCreationException;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.mgbean.ManagedBeanPreProcessingException;
import com.sun.faces.mgbean.ManagedListBeanBuilder;
import com.sun.faces.mgbean.ManagedMapBeanBuilder;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManager {
    private static final Logger LOGGER = FacesLogger.MANAGEDBEAN.getLogger();
    private Map<String, BeanBuilder> managedBeans = new HashMap<String, BeanBuilder>();
    private InjectionProvider injectionProvider;
    private boolean configPreprocessed;
    private boolean lazyBeanValidation;

    public BeanManager(InjectionProvider injectionProvider, boolean bl) {
        this.injectionProvider = injectionProvider;
        this.lazyBeanValidation = bl;
    }

    public BeanManager(InjectionProvider injectionProvider, Map<String, BeanBuilder> map, boolean bl) {
        this(injectionProvider, bl);
        this.managedBeans = map;
    }

    public void register(ManagedBeanInfo managedBeanInfo) {
        if (managedBeanInfo.hasListEntry()) {
            if (managedBeanInfo.hasMapEntry() || managedBeanInfo.hasManagedProperties()) {
                String string = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_LIST_CONFIG_ERROR", managedBeanInfo.getName());
                this.addBean(managedBeanInfo.getName(), new ErrorBean(managedBeanInfo, string));
            } else {
                this.addBean(managedBeanInfo.getName(), new ManagedListBeanBuilder(managedBeanInfo));
            }
        } else if (managedBeanInfo.hasMapEntry()) {
            if (managedBeanInfo.hasManagedProperties()) {
                String string = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_MAP_CONFIG_ERROR", managedBeanInfo.getName());
                this.addBean(managedBeanInfo.getName(), new ErrorBean(managedBeanInfo, string));
            } else {
                this.addBean(managedBeanInfo.getName(), new ManagedMapBeanBuilder(managedBeanInfo));
            }
        } else {
            this.addBean(managedBeanInfo.getName(), new ManagedBeanBuilder(managedBeanInfo));
        }
    }

    public Map<String, BeanBuilder> getRegisteredBeans() {
        return this.managedBeans;
    }

    public boolean isManaged(String string) {
        return this.managedBeans != null && this.managedBeans.containsKey(string);
    }

    public BeanBuilder getBuilder(String string) {
        if (this.managedBeans != null) {
            return this.managedBeans.get(string);
        }
        return null;
    }

    public void preProcessesBeans() {
        if (!this.configPreprocessed && !this.lazyBeanValidation) {
            this.configPreprocessed = true;
            for (Map.Entry<String, BeanBuilder> entry : this.managedBeans.entrySet()) {
                this.preProcessBean(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isBeanInScope(String string, FacesContext facesContext) {
        ELUtils.Scope scope = this.getBuilder(string).getScope();
        ExternalContext externalContext = facesContext.getExternalContext();
        switch (scope) {
            case REQUEST: {
                if (externalContext.getRequestMap().containsKey(string)) {
                    return true;
                }
            }
            case SESSION: {
                if (externalContext.getSessionMap().containsKey(string)) {
                    return true;
                }
            }
            case APPLICATION: {
                if (!externalContext.getApplicationMap().containsKey(string)) break;
                return true;
            }
        }
        return false;
    }

    public Object getBeanFromScope(String string, BeanBuilder beanBuilder, FacesContext facesContext) {
        return ScopeManager.getFromScope(string, beanBuilder.getScope(), facesContext);
    }

    public Object getBeanFromScope(String string, FacesContext facesContext) {
        ELUtils.Scope scope = this.getBuilder(string).getScope();
        return ScopeManager.getFromScope(string, scope, facesContext);
    }

    public Object create(String string, BeanBuilder beanBuilder, FacesContext facesContext) {
        if (beanBuilder != null) {
            if (this.lazyBeanValidation && !beanBuilder.isBaked()) {
                this.preProcessBean(string, beanBuilder);
            }
            if (beanBuilder.hasMessages()) {
                throw new ManagedBeanCreationException(this.buildMessage(string, beanBuilder.getMessages(), true));
            }
            return this.createAndPush(string, beanBuilder, facesContext);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(String string, FacesContext facesContext) {
        BeanBuilder beanBuilder = this.managedBeans.get(string);
        if (beanBuilder != null) {
            Object object;
            if (this.lazyBeanValidation && !beanBuilder.isBaked()) {
                this.preProcessBean(string, beanBuilder);
            }
            if (beanBuilder.hasMessages()) {
                throw new ManagedBeanCreationException(this.buildMessage(string, beanBuilder.getMessages(), true));
            }
            ELUtils.Scope scope = beanBuilder.getScope();
            switch (scope) {
                case APPLICATION: {
                    Object object2 = facesContext.getExternalContext().getContext();
                    synchronized (object2) {
                        object = this.createAndPush(string, beanBuilder, scope, facesContext);
                        break;
                    }
                }
                case SESSION: {
                    Object object3 = facesContext.getExternalContext().getSession(true);
                    synchronized (object3) {
                        object = this.createAndPush(string, beanBuilder, scope, facesContext);
                        break;
                    }
                }
                default: {
                    object = this.createAndPush(string, beanBuilder, scope, facesContext);
                }
            }
            return object;
        }
        return null;
    }

    public void destroy(String string, Object object) {
        BeanBuilder beanBuilder = this.managedBeans.get(string);
        if (beanBuilder != null) {
            beanBuilder.destroy(this.injectionProvider, object);
        }
    }

    private void addBean(String string, BeanBuilder beanBuilder) {
        if (this.configPreprocessed) {
            this.preProcessBean(string, beanBuilder);
        }
        this.managedBeans.put(string, beanBuilder);
    }

    private void validateReferences(BeanBuilder beanBuilder, List<String> list, List<String> list2) {
        List<String> list3 = beanBuilder.getReferences();
        if (list3 != null) {
            for (String string : list3) {
                Object object;
                if (!this.isManaged(string)) continue;
                if (list.contains(string)) {
                    object = new StringBuilder(64);
                    String[] stringArray = list.toArray(new String[list.size()]);
                    for (int i = 0; i < stringArray.length; ++i) {
                        ((StringBuilder)object).append(stringArray[i]);
                        ((StringBuilder)object).append(" -> ");
                    }
                    ((StringBuilder)object).append(string);
                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.CYCLIC_REFERENCE_ERROR", stringArray[0], ((StringBuilder)object).toString());
                    list2.add(string2);
                    continue;
                }
                object = this.getBuilder(string);
                if (((BeanBuilder)object).getReferences() == null) continue;
                list.add(string);
                this.validateReferences((BeanBuilder)object, list, list2);
                list.remove(string);
            }
        }
    }

    private synchronized void preProcessBean(String string, BeanBuilder beanBuilder) {
        if (!beanBuilder.isBaked()) {
            try {
                beanBuilder.bake();
                List<String> list = beanBuilder.getReferences();
                if (list != null) {
                    for (String object2 : list) {
                        if (!this.isManaged(object2)) continue;
                        BeanBuilder beanBuilder2 = this.getBuilder(object2);
                        this.preProcessBean(object2, beanBuilder2);
                    }
                }
                ArrayList arrayList = new ArrayList();
                arrayList.add(string);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                this.validateReferences(beanBuilder, arrayList, arrayList2);
                if (!arrayList2.isEmpty()) {
                    beanBuilder.queueMessages(arrayList2);
                }
                if (beanBuilder.hasMessages() && LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, this.buildMessage(string, beanBuilder.getMessages(), false));
                }
            }
            catch (ManagedBeanPreProcessingException managedBeanPreProcessingException) {
                if (ManagedBeanPreProcessingException.Type.CHECKED.equals((Object)managedBeanPreProcessingException.getType())) {
                    beanBuilder.queueMessage(managedBeanPreProcessingException.getMessage());
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, this.buildMessage(string, beanBuilder.getMessages(), false));
                    }
                }
                String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNKNOWN_PROCESSING_ERROR", string);
                throw new ManagedBeanPreProcessingException(string2, (Throwable)((Object)managedBeanPreProcessingException));
            }
        }
    }

    private Object createAndPush(String string, BeanBuilder beanBuilder, ELUtils.Scope scope, FacesContext facesContext) {
        Object object = beanBuilder.build(this.injectionProvider, facesContext);
        ScopeManager.pushToScope(string, object, scope, facesContext);
        return object;
    }

    private Object createAndPush(String string, BeanBuilder beanBuilder, FacesContext facesContext) {
        Object object = beanBuilder.build(this.injectionProvider, facesContext);
        ScopeManager.pushToScope(string, object, beanBuilder.getScope(), facesContext);
        return object;
    }

    private String buildMessage(String string, List<String> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (bl) {
            stringBuilder.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_ERROR", string));
        } else {
            stringBuilder.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_STARTUP_ERROR", string));
        }
        for (String string2 : list) {
            stringBuilder.append("\n     - ").append(string2);
        }
        return stringBuilder.toString();
    }

    private static class ScopeManager {
        private static final EnumMap<ELUtils.Scope, ScopeHandler> handlerMap = new EnumMap(ELUtils.Scope.class);

        private ScopeManager() {
        }

        static void pushToScope(String string, Object object, ELUtils.Scope scope, FacesContext facesContext) {
            ScopeHandler scopeHandler = handlerMap.get((Object)scope);
            if (scopeHandler != null) {
                scopeHandler.handle(string, object, facesContext);
            }
        }

        static Object getFromScope(String string, ELUtils.Scope scope, FacesContext facesContext) {
            ScopeHandler scopeHandler = handlerMap.get((Object)scope);
            if (scopeHandler != null) {
                return scopeHandler.getFromScope(string, facesContext);
            }
            return null;
        }

        static {
            handlerMap.put(ELUtils.Scope.REQUEST, new RequestScopeHandler());
            handlerMap.put(ELUtils.Scope.SESSION, new SessionScopeHandler());
            handlerMap.put(ELUtils.Scope.APPLICATION, new ApplicationScopeHandler());
        }

        private static class ApplicationScopeHandler
        implements ScopeHandler {
            private ApplicationScopeHandler() {
            }

            public void handle(String string, Object object, FacesContext facesContext) {
                facesContext.getExternalContext().getApplicationMap().put(string, object);
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getApplicationMap().get(string);
            }
        }

        private static class SessionScopeHandler
        implements ScopeHandler {
            private SessionScopeHandler() {
            }

            public void handle(String string, Object object, FacesContext facesContext) {
                facesContext.getExternalContext().getSessionMap().put(string, object);
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getSessionMap().get(string);
            }
        }

        private static class RequestScopeHandler
        implements ScopeHandler {
            private RequestScopeHandler() {
            }

            public void handle(String string, Object object, FacesContext facesContext) {
                facesContext.getExternalContext().getRequestMap().put(string, object);
            }

            public Object getFromScope(String string, FacesContext facesContext) {
                return facesContext.getExternalContext().getRequestMap().get(string);
            }
        }

        private static interface ScopeHandler {
            public void handle(String var1, Object var2, FacesContext var3);

            public Object getFromScope(String var1, FacesContext var2);
        }
    }
}

