/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

public class ListDataModel
extends DataModel {
    private int index = -1;
    private List list;

    public ListDataModel() {
        this(null);
    }

    public ListDataModel(List list) {
        this.setWrappedData(list);
    }

    public boolean isRowAvailable() {
        if (this.list == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.list.size();
    }

    public int getRowCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public Object getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return this.list.get(this.index);
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        int n2 = this.index;
        this.index = n;
        if (this.list == null) {
            return;
        }
        DataModelListener[] dataModelListenerArray = this.getDataModelListeners();
        if (n2 != this.index && dataModelListenerArray != null) {
            Object object = null;
            if (this.isRowAvailable()) {
                object = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this, this.index, object);
            int n3 = dataModelListenerArray.length;
            for (int i = 0; i < n3; ++i) {
                if (null == dataModelListenerArray[i]) continue;
                dataModelListenerArray[i].rowSelected(dataModelEvent);
            }
        }
    }

    public Object getWrappedData() {
        return this.list;
    }

    public void setWrappedData(Object object) {
        if (object == null) {
            this.list = null;
            this.setRowIndex(-1);
        } else {
            this.list = (List)object;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

