/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.extension.microprofile.health;

import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.SUBSYSTEM;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthExtension.SUBSYSTEM_NAME;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthMigrateOperation.HEALTH_SUBSYSTEM_NAME;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition.EMPTY_LIVENESS_CHECKS_STATUS;
import static org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition.EMPTY_READINESS_CHECKS_STATUS;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class MicroProfileHealthMigrateTestCase extends AbstractSubsystemTest {

    public MicroProfileHealthMigrateTestCase() {
        super(SUBSYSTEM_NAME, new MicroProfileHealthExtension());
    }

    @Test
    public void migrateTest() throws Exception {
        MicroProfileHealthAdditionalInit.extensionAdded = false;

        KernelServices services =
                createKernelServicesBuilder(new MicroProfileHealthAdditionalInit(true))
                        .setSubsystemXmlResource("subsystem_2_0.xml")
                        .build();
        ModelNode legacyModel = services.readWholeModel();
        Assert.assertFalse(MicroProfileHealthAdditionalInit.extensionAdded);

        ModelNode migrateOp = Util.createOperation(MicroProfileHealthMigrateOperation.MIGRATE, PathAddress.pathAddress(SUBSYSTEM, SUBSYSTEM_NAME));
        checkOutcome(services.executeOperation(migrateOp));

        ModelNode model = services.readWholeModel();


        Assert.assertFalse(model.get(SUBSYSTEM).hasDefined(SUBSYSTEM_NAME));
        Assert.assertTrue(MicroProfileHealthAdditionalInit.extensionAdded);
        Assert.assertTrue(model.get(SUBSYSTEM).hasDefined(HEALTH_SUBSYSTEM_NAME));
        ModelNode legacySubsystem = legacyModel.get(SUBSYSTEM, SUBSYSTEM_NAME);

        // These attributes only exist in the legacy subsystem
        legacySubsystem.remove(EMPTY_LIVENESS_CHECKS_STATUS.getName());
        legacySubsystem.remove(EMPTY_READINESS_CHECKS_STATUS.getName());
        ModelNode subsystem = model.get(SUBSYSTEM, HEALTH_SUBSYSTEM_NAME);
        Assert.assertEquals(legacySubsystem, subsystem);
    }
}
