/*
 * Copyright (c) 2022. Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.as.test.integration.security.jaas;

import java.io.IOException;
import java.io.PrintWriter;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <p>Servlet that performs a login over the security domain <em>other</em>
 * using JAAS LoginContext.</p>
 *
 * @author rmartinc
 */
@WebServlet(LoginContextServlet.SERVLET_PATH)
public class LoginContextServlet extends HttpServlet {

    public static final String SERVLET_PATH = "/login";
    public static final String DEFAULT_CONTEXT = "other";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        String message;
        final String username = request.getParameter("username");
        final String password = request.getParameter("password");
        final String loginContext = request.getParameter("context") != null?
                request.getParameter("context") : DEFAULT_CONTEXT;

        try {
            final CallbackHandler handler = callback -> {
                for (int i = 0; i < callback.length; i++) {
                    if (callback[i] instanceof NameCallback && username != null) {
                        final NameCallback nameCallback = (NameCallback) callback[i];
                        nameCallback.setName(username);
                    } else if (callback[i] instanceof PasswordCallback && password != null) {
                        final PasswordCallback passCallback = (PasswordCallback) callback[i];
                        passCallback.setPassword(password.toCharArray());
                    }
                }
            };

            LoginContext login = new LoginContext(loginContext, handler);
            login.login();
            message = "Login success";
        } catch (LoginException e) {
            message = "Login failed: " + e.getMessage();
        }

        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain");
        try (PrintWriter out = response.getWriter()) {
            out.print(message);
        }
    }
}
