/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.extension.microprofile.opentracing;

import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.EXTENSION;
import static org.jboss.as.controller.descriptions.ModelDescriptionConstants.SUBSYSTEM;
import static org.wildfly.extension.microprofile.opentracing.SubsystemExtension.EXTENSION_ADDR;
import static org.wildfly.extension.microprofile.opentracing.SubsystemExtension.SUBSYSTEM_NAME;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class MPOpentracingMigrateTestCase extends AbstractSubsystemTest {

    public MPOpentracingMigrateTestCase() {
        super(SUBSYSTEM_NAME, new SubsystemExtension());
    }

    @Test
    public void migrateTest() throws Exception {
        KernelServices services =
                createKernelServicesBuilder(new MPOpentracingAdditionalInit())
                        .setSubsystemXmlResource("subsystem_3_0.xml")
                        .build();

        ModelNode migrateOp = Util.createOperation(TracingMigrateOperation.MIGRATE, PathAddress.pathAddress(SUBSYSTEM, SUBSYSTEM_NAME));
        checkOutcome(services.executeOperation(migrateOp));

        ModelNode model = services.readWholeModel();

        Assert.assertFalse(model.get(SUBSYSTEM).hasDefined(SUBSYSTEM_NAME));
        Assert.assertFalse(model.get(EXTENSION).hasDefined(EXTENSION_ADDR.getLastElement().getValue()));
    }
}
